/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HK2Main
extends Main
implements BundleActivator,
SynchronousBundleListener {
    private BundleContext ctx;
    private ModulesRegistry mr;
    private static final String pid = "org.jvnet.hk2.osgiadapter.StartupContextService";
    private StartupContextService startupContextService;

    public void start(BundleContext context) throws Exception {
        this.ctx = context;
        Logger.logger.entering("HK2Main", "start", new Object[]{context});
        OSGiFactoryImpl.initialize(this.ctx);
        this.mr = this.createModulesRegistry();
        Properties p = new Properties();
        p.setProperty("service.pid", pid);
        this.startupContextService = new StartupContextService();
        context.registerService(ManagedService.class.getName(), (Object)this.startupContextService, (Dictionary)p);
    }

    protected ModulesRegistry createModulesRegistry() {
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        return mr;
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
    }

    public void stop(BundleContext context) throws Exception {
        if (this.startupContextService.startupService != null) {
            try {
                Logger.logger.info("Stopping " + this.startupContextService.startupService);
                this.startupContextService.startupService.stop();
            }
            catch (Exception e) {
                Logger.logger.log(Level.WARNING, "HK2Main:stop():Exception while stopping ModuleStartup service.", e);
            }
        }
        this.startupContextService.updated(null);
        this.startupContextService = null;
        if (this.mr != null) {
            this.mr.shutdown();
            this.mr = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, "HK2Main", "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
    }

    private class HK2ServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private final Habitat habitat;

        private HK2ServiceTrackerCustomizer(Habitat habitat) {
            this.habitat = habitat;
        }

        public Object addingService(ServiceReference reference) {
            Object object = HK2Main.this.ctx.getService(reference);
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    String name = (String)reference.getProperty("component.name");
                    if (name == null) {
                        name = (String)reference.getProperty("org.springframework.osgi.bean.name");
                    }
                    this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant(object), contractName, name);
                    Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}, contract = {1}, name = {2}", new Object[]{object, contractName, name});
                }
            } else {
                this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(object));
                Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}", object);
            }
            return object;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    this.habitat.removeIndex(contractName, service);
                    Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "removingService", "removing service = {0}, contract = {1}", new Object[]{service, contractName});
                }
            } else {
                Inhabitant inhabitant = this.habitat.getInhabitantByType(service.getClass());
                if (inhabitant != null) {
                    this.habitat.remove(inhabitant);
                } else {
                    Logger.logger.logp(Level.WARNING, "HK2Main$HK2ServiceTrackerCustomizer", "removedService", "cannot removed singleton service = {0}", service);
                }
            }
        }
    }

    private class NonHK2ServiceFilter
    implements Filter {
        private NonHK2ServiceFilter() {
        }

        public boolean match(ServiceReference serviceReference) {
            return !HK2Main.this.ctx.getBundle().equals(serviceReference.getBundle());
        }

        public boolean match(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public boolean matchCase(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public String toString() {
            return "(objectClass=*)";
        }
    }

    private class StartupContextService
    implements ManagedService {
        private Habitat habitat;
        private ServiceRegistration habitatRegistration;
        private ServiceTracker osgiServiceTracker;
        private ServiceRegistration moduleStartupRegistration;
        private ModuleStartup startupService;

        private StartupContextService() {
        }

        public synchronized void updated(Dictionary props) throws ConfigurationException {
            if (props == null) {
                if (this.habitat == null) {
                    return;
                }
                this.destroyHabitat(this.habitat);
                this.habitat = null;
                this.startupService = null;
                if (this.moduleStartupRegistration != null) {
                    this.moduleStartupRegistration.unregister();
                    this.moduleStartupRegistration = null;
                    this.habitatRegistration.unregister();
                    this.habitatRegistration = null;
                }
            } else {
                StartupContext startupContext = new StartupContext(this.dict2Props(props));
                try {
                    this.habitat = this.createHabitat(HK2Main.this.mr, startupContext);
                    this.startupService = HK2Main.this.findStartupService(HK2Main.this.mr, this.habitat, startupContext.getStartupModuleName(), startupContext);
                    this.moduleStartupRegistration = HK2Main.this.ctx.registerService(ModuleStartup.class.getName(), (Object)this.startupService, props);
                }
                catch (BootException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
            Habitat habitat = HK2Main.this.createHabitat(registry, context);
            this.createServiceTracker(habitat);
            this.habitatRegistration = HK2Main.this.ctx.registerService(Habitat.class.getName(), (Object)habitat, (Dictionary)context.getArguments());
            return habitat;
        }

        private void destroyHabitat(Habitat habitat) {
            this.stopServiceTracker(habitat);
            habitat.release();
        }

        private void createServiceTracker(Habitat habitat) {
            this.osgiServiceTracker = new ServiceTracker(HK2Main.this.ctx, (Filter)new NonHK2ServiceFilter(), (ServiceTrackerCustomizer)new HK2ServiceTrackerCustomizer(habitat));
            this.osgiServiceTracker.open(true);
        }

        private void stopServiceTracker(Habitat habitat) {
            if (this.osgiServiceTracker != null) {
                this.osgiServiceTracker.close();
                this.osgiServiceTracker = null;
            }
        }

        private Properties dict2Props(Dictionary dict) {
            Properties props = new Properties();
            Enumeration e = dict.keys();
            while (e.hasMoreElements()) {
                String k = e.nextElement().toString();
                props.put(k, dict.get(k).toString());
            }
            return props;
        }
    }
}

