/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LocalAdminCommand {
    private final File asadmin;
    private final List<String> cmds = new ArrayList<String>();
    private ProcessManager pm;

    public LocalAdminCommand(String command, String ... args) {
        this.asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation());
        this.cmds.add(this.asadmin.getAbsolutePath());
        this.cmds.add(command);
        if (args != null && args.length > 0) {
            this.cmds.addAll(Arrays.asList(args));
        }
    }

    public int execute() throws ProcessManagerException {
        if (!this.asadmin.canExecute()) {
            throw new ProcessManagerException("asadmin is not executable!");
        }
        this.pm = new ProcessManager(this.cmds);
        this.pm.execute();
        return this.pm.getExitValue();
    }

    public ProcessManager getProcessManager() {
        return this.pm;
    }
}

