/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="create-resource-ref")
@Scoped(value=PerLookup.class)
@I18n(value="create.resource.ref")
public class CreateResourceRef
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceRef.class);
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String target = "server";
    @Param(name="reference_name", primary=true)
    private String refName;
    @Inject
    private Domain domain;
    @Inject
    private Resources resources;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceExists(this.refName)) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.resourceDoesNotExist", "Resource {0} does not exist", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Server server = ConfigBeansUtilities.getServerNamed((String)this.target);
            if (server != null) {
                if (server.isResourceRefExists(this.refName)) {
                    report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready", "Resource ref {0} already exists", this.refName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                server.createResourceRef(this.enabled.toString(), this.refName);
            } else {
                com.sun.enterprise.config.serverbeans.Cluster cluster = this.domain.getClusterNamed(this.target);
                if (cluster.isResourceRefExists(this.refName)) {
                    report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready", "Resource ref {0} already exists", this.refName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                cluster.createResourceRef(this.enabled.toString(), this.refName);
                Target tgt = (Target)this.habitat.getComponent(Target.class);
                List<Server> instances = tgt.getInstances(this.target);
                for (Server svr : instances) {
                    svr.createResourceRef(this.enabled.toString(), this.refName);
                }
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }

    private boolean isResourceExists(String jndiName) {
        return this.resources.getResourceByName(BindableResource.class, jndiName) != null;
    }
}

