/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="delete-resource-ref")
@Scoped(value=PerLookup.class)
@I18n(value="delete.resource.ref")
public class DeleteResourceRef
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteResourceRef.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="reference_name", primary=true)
    private String refName;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;
    @Inject
    private Habitat habitat;
    @Inject
    private Domain domain;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Server server = ConfigBeansUtilities.getServerNamed((String)this.target);
            if (server != null) {
                if (!server.isResourceRefExists(this.refName)) {
                    this.setResourceRefDoNotExistMessage(report);
                    return;
                }
                server.deleteResourceRef(this.refName);
            } else {
                com.sun.enterprise.config.serverbeans.Cluster cluster = this.domain.getClusterNamed(this.target);
                if (!cluster.isResourceRefExists(this.refName)) {
                    this.setResourceRefDoNotExistMessage(report);
                    return;
                }
                cluster.deleteResourceRef(this.refName);
                Target tgt = (Target)this.habitat.getComponent(Target.class);
                List<Server> instances = tgt.getInstances(this.target);
                for (Server svr : instances) {
                    svr.deleteResourceRef(this.refName);
                }
            }
        }
        catch (Exception e) {
            this.setFailureMessage(report, e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void setResourceRefDoNotExistMessage(ActionReport report) {
        report.setMessage(localStrings.getLocalString("delete.resource.ref.doesNotExist", "A resource ref named {0} does not exist.", this.refName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setFailureMessage(ActionReport report, Exception e) {
        report.setMessage(localStrings.getLocalString("delete.resource.ref.failed", "Resource ref {0} deletion failed", this.refName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause((Throwable)e);
    }
}

