/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolver {
    private Domain _domain = null;
    private Cluster _cluster = null;
    private Server _server = null;
    private Config _config = null;

    public PropertyResolver(Domain domain, String instanceName) {
        this._domain = domain;
        this._server = this._domain.getServerNamed(instanceName);
        this._config = this._domain.getConfigNamed(this._server.getConfigRef());
        this._cluster = this._domain.getClusterForInstance(instanceName);
    }

    private String getPropertyValue(String propName, List<SystemProperty> props) {
        String propVal = null;
        for (SystemProperty prop : props) {
            if (!prop.getName().equals(propName)) continue;
            return prop.getValue();
        }
        return propVal;
    }

    public String getPropertyValue(String propName) {
        if (propName.startsWith("${") && propName.endsWith("}")) {
            propName = propName.substring(2, propName.lastIndexOf("}"));
        }
        String propVal = null;
        if (this._server != null) {
            propVal = this.getPropertyValue(propName, this._server.getSystemProperty());
        }
        if (propVal == null) {
            if (this._cluster != null) {
                propVal = this.getPropertyValue(propName, this._cluster.getSystemProperty());
            }
            if (propVal == null && this._config != null && (propVal = this.getPropertyValue(propName, this._config.getSystemProperty())) == null && this._domain != null) {
                propVal = this.getPropertyValue(propName, this._domain.getSystemProperty());
            }
        }
        return propVal;
    }
}

