/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.container.Sniffer;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-components")
@I18n(value="list.components")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class ListComponentsCommand
implements AdminCommand {
    @Param(optional=true)
    String type = null;
    @Param(primary=true, optional=true)
    public String target = "server";
    @Param(optional=true, defaultValue="false", shortName="v")
    public Boolean verbose = false;
    @Inject
    protected Domain domain;
    @Inject
    SnifferManager snifferManager;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        for (Application app : this.domain.getApplicationsInTarget(this.target)) {
            if (!app.getObjectType().equals("user") || this.type != null && !this.isApplicationOfThisType(app, this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            String message = app.getName() + " " + this.getAppSnifferEngines(app, true);
            if (this.verbose.booleanValue()) {
                message = message + this.getVerboseStatus(app);
            }
            childPart.setMessage(message);
            ++numOfApplications;
        }
        if (numOfApplications == 0) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String getVerboseStatus(Application app) {
        String message = "";
        if (DeploymentUtils.isDomainTarget((String)this.target)) {
            return message;
        }
        boolean isVersionEnabled = this.domain.isAppEnabledInTarget(app.getName(), this.target);
        message = isVersionEnabled ? localStrings.getLocalString("list.applications.verbose.enabled", "(enabled)") : localStrings.getLocalString("list.applications.verbose.disabled", "(disabled)");
        return message;
    }

    boolean isApplicationOfThisType(Application app, String type) {
        if (type.equals("application")) {
            type = "ear";
        } else if (type.equals("webservice")) {
            type = "webservices";
        }
        List<Engine> engineList = this.getAppEngines(app);
        for (Engine engine : engineList) {
            if (!engine.getSniffer().equals(type)) continue;
            return true;
        }
        return false;
    }

    String getAppSnifferEngines(Application app, boolean format) {
        return this.getSniffers(this.getAppEngines(app), format);
    }

    String getSnifferEngines(Module module, boolean format) {
        return this.getSniffers(module.getEngines(), format);
    }

    private String getSniffers(List<Engine> engineList, boolean format) {
        LinkedHashSet<String> snifferSet = new LinkedHashSet<String>();
        for (Engine engine : engineList) {
            String engType = engine.getSniffer();
            if (!this.displaySnifferEngine(engType)) continue;
            snifferSet.add(engine.getSniffer());
        }
        StringBuffer se = new StringBuffer();
        if (!snifferSet.isEmpty()) {
            if (format) {
                se.append("<");
            }
            for (String sniffer : snifferSet) {
                se.append(sniffer + ", ");
            }
            if (se.length() > 2) {
                se.replace(se.length() - 2, se.length(), format ? ">" : "");
            } else if (format) {
                se.append(">");
            }
        }
        return se.toString();
    }

    private List<Engine> getAppEngines(Application app) {
        ArrayList<Engine> engineList = new ArrayList<Engine>();
        engineList.addAll(app.getEngine());
        for (Module module : app.getModule()) {
            engineList.addAll(module.getEngines());
        }
        return engineList;
    }

    boolean displaySnifferEngine(String engType) {
        Sniffer sniffer = this.snifferManager.getSniffer(engType);
        return sniffer.isUserVisible();
    }
}

