/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.LegacyConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="set")
@Scoped(value=PerLookup.class)
@I18n(value="set")
public class SetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    ConfigSupport config;
    @Param(primary=true, multiple=true)
    String[] values;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetCommand.class);

    public void execute(AdminCommandContext context) {
        for (String value : this.values) {
            if (this.set(context, value)) continue;
            return;
        }
    }

    private boolean set(AdminCommandContext context, String nameval) {
        int i = nameval.indexOf(61);
        if (i < 0) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.namevalue", "Invalid name value pair {0}. Missing expected equal sign.", new Object[]{nameval}));
            return false;
        }
        String target = nameval.substring(0, i);
        String value = nameval.substring(i + 1);
        int lastDotIndex = SetCommand.trueLastIndexOf(target, '.');
        if (lastDotIndex == -1) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.attributename", "Invalid attribute name {0}", new Object[]{target}));
            return false;
        }
        String attrName = target.substring(lastDotIndex + 1);
        String pattern = target.substring(0, lastDotIndex);
        if (attrName.replace('_', '-').equals("jndi-name")) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.reject.keychange", "Cannot change a primary key\nChange of {0}", new Object[]{target}));
            return false;
        }
        boolean isProperty = false;
        if ("property".equals(pattern.substring(pattern.lastIndexOf(46) + 1))) {
            pattern = target.replaceAll("\\\\\\.", "\\.");
            isProperty = true;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = pattern.substring(0, pattern.indexOf(parentNodes[0].relativeName));
        }
        pattern = parentNodes[0].relativeName;
        String targetName = prefix + pattern;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, pattern);
        if (matchingNodes.isEmpty() && (pattern = target.substring(0, target.lastIndexOf(46))).endsWith("property")) {
            V2DottedNameSupport.TreeNode parentNode;
            pattern = pattern.substring(0, pattern.lastIndexOf(46));
            parentNodes = this.getAliasedParent(this.domain, pattern);
            pattern = parentNodes[0].relativeName;
            matchingNodes = this.getMatchingNodes(dottedNames, pattern);
            if (matchingNodes.isEmpty()) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            parentNode = null;
            for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
                if (!node.getValue().equals(pattern)) continue;
                parentNode = node.getKey();
            }
            if (parentNode == null) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("value", value);
            attributes.put("name", attrName);
            try {
                ConfigSupport.createAndSet((ConfigBean)((ConfigBean)parentNode), Property.class, attributes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
                return true;
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        }
        HashMap changes = new HashMap();
        boolean delPropertySuccess = false;
        boolean delProperty = false;
        HashMap<String, String> attrChanges = new HashMap<String, String>();
        if (isProperty) {
            attrName = "value";
            if (value == null || value.length() == 0) {
                delProperty = true;
            }
            attrChanges.put(attrName, value);
        }
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            Dom targetNode = node.getKey();
            for (String name : targetNode.model.getAttributeNames()) {
                String finalDottedName = node.getValue() + "." + name;
                if (!this.matches(finalDottedName, pattern) || !attrName.equals(name) && !attrName.replace('_', '-').equals(name.replace('_', '-'))) continue;
                if (!isProperty) {
                    targetName = prefix + finalDottedName;
                    if (value != null && value.length() > 0) {
                        attrChanges.put(name, value);
                    } else {
                        attrChanges.put(name, null);
                    }
                } else {
                    targetName = prefix + node.getValue();
                }
                if (delProperty) {
                    String str = node.getValue();
                    if (str.lastIndexOf(46) != -1) {
                        str = str.substring(str.lastIndexOf(46) + 1);
                    }
                    try {
                        if (str == null) continue;
                        ConfigSupport.deleteChild((ConfigBean)((ConfigBean)targetNode.parent()), (ConfigBean)((ConfigBean)targetNode));
                        delPropertySuccess = true;
                        continue;
                    }
                    catch (IllegalArgumentException ie) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.delete.property.failure", "Could not delete the property: {0}", new Object[]{ie.getMessage()}), ie);
                        return false;
                    }
                    catch (TransactionFailure transactionFailure) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                        return false;
                    }
                }
                changes.put((ConfigBean)node.getKey(), attrChanges);
            }
        }
        if (!changes.isEmpty()) {
            try {
                this.config.apply(changes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        } else if (delPropertySuccess) {
            this.success(context, targetName, value);
        } else {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
            return false;
        }
        return true;
    }

    private void runLegacyChecks(AdminCommandContext context) {
        Collection list = this.habitat.getAllByContract(LegacyConfigurationUpgrade.class);
        for (LegacyConfigurationUpgrade upgrade : list) {
            upgrade.execute(context);
        }
    }

    private static int trueLastIndexOf(String target, char ch) {
        int i = target.lastIndexOf(ch);
        while (i > 0 && target.charAt(i - 1) == '\\') {
            i = target.lastIndexOf(ch, i - 1);
        }
        return i;
    }

    private static void fail(AdminCommandContext context, String msg) {
        SetCommand.fail(context, msg, null);
    }

    private static void fail(AdminCommandContext context, String msg, Exception ex) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (ex != null) {
            context.getActionReport().setFailureCause(ex);
        }
        context.getActionReport().setMessage(msg);
    }

    private void success(AdminCommandContext context, String target, String value) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart part = context.getActionReport().getTopMessagePart().addChild();
        part.setChildrenType("DottedName");
        part.setMessage(target + "=" + value);
    }
}

