/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.glassfish.experimentalgfapi.GlassFish;
import org.glassfish.experimentalgfapi.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class GlassFishActivator
implements BundleActivator {
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.startBundles();
        this.registerGlassFishRuntime();
    }

    private void registerGlassFishRuntime() throws InterruptedException {
        final ServiceTracker hk2Tracker = new ServiceTracker(this.bundleContext, Main.class.getName(), null);
        hk2Tracker.open();
        this.bundleContext.registerService(GlassFishRuntime.class.getName(), (Object)new GlassFishRuntime(){

            public GlassFish newGlassFish(Properties properties) throws Exception {
                GlassFishActivator.this.setEnv(properties);
                StartupContext startupContext = new StartupContext(properties);
                Main main = (Main)hk2Tracker.waitForService(0L);
                ModulesRegistry mr = (ModulesRegistry)ModulesRegistry.class.cast(GlassFishActivator.this.bundleContext.getService(GlassFishActivator.this.bundleContext.getServiceReference(ModulesRegistry.class.getName())));
                final Habitat habitat = main.createHabitat(mr, startupContext);
                final ModuleStartup gfKernel = main.findStartupService(mr, habitat, null, startupContext);
                System.out.println("gfKernel = " + gfKernel);
                return new GlassFish(){
                    volatile GlassFish.Status status = GlassFish.Status.INIT;

                    @Override
                    public synchronized void start() {
                        try {
                            this.status = GlassFish.Status.STARTING;
                            gfKernel.start();
                            this.status = GlassFish.Status.STARTED;
                            GlassFishActivator.this.startPostStartupBundles();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public synchronized void stop() {
                        if (this.status != GlassFish.Status.STARTED) {
                            return;
                        }
                        try {
                            this.status = GlassFish.Status.STOPPING;
                            gfKernel.stop();
                            this.status = GlassFish.Status.STOPPED;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public synchronized void dispose() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public synchronized GlassFish.Status getStatus() {
                        return this.status;
                    }

                    @Override
                    public synchronized <T> T lookupService(Class<T> serviceType, String servicetName) {
                        if (this.status != GlassFish.Status.STARTED) {
                            throw new IllegalArgumentException("Server is not started yet. It is in " + (Object)((Object)this.status) + "state");
                        }
                        return (T)habitat.getComponent(serviceType, servicetName);
                    }
                };
            }
        }, null);
    }

    private Properties dict2Properties(Dictionary dictionary) {
        Properties args = new Properties();
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            String v = dictionary.get(k).toString();
            args.put(k, v);
        }
        return args;
    }

    public void stop(BundleContext context) throws Exception {
        this.stopBundle("com.sun.enterprise.osgi-adapter");
    }

    private void setEnv(Properties properties) {
        String instanceRootValue;
        String installRootValue = properties.getProperty("com.sun.aas.installRoot");
        if (installRootValue != null && !installRootValue.isEmpty()) {
            File installRoot = new File(installRootValue);
            System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            Properties asenv = ASMainHelper.parseAsEnv(installRoot);
            for (String s : asenv.stringPropertyNames()) {
                System.setProperty(s, asenv.getProperty(s));
            }
            System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if ((instanceRootValue = properties.getProperty("com.sun.aas.instanceRoot")) != null && !instanceRootValue.isEmpty()) {
            File instanceRoot = new File(instanceRootValue);
            System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
    }

    private void startBundles() {
        this.startConfigAdmin();
        this.startBundle("com.sun.enterprise.osgi-adapter");
    }

    private void startPostStartupBundles() {
        this.startBundle("org.apache.felix.shell");
        this.startBundle("org.apache.felix.org.apache.felix.shell.remote");
        this.startBundle("org.apache.felix.fileinstall");
    }

    private void startConfigAdmin() {
        ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (sr == null) {
            this.startBundle("org.apache.felix.configadmin");
        } else {
            this.bundleContext.ungetService(sr);
        }
    }

    private void startBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.start(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to start: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private void stopBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.stop(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to stop: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private Bundle findBundle(String bsn) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!bsn.equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }
}

