/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.AutoProcessor;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.glassfish.experimentalgfapi.Constants;
import org.glassfish.experimentalgfapi.GlassFishRuntime;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiGlassFishRuntimeBuilder
implements GlassFishRuntime.RuntimeBuilder {
    private Framework framework;
    private Properties properties;

    public GlassFishRuntime build(Properties properties) throws Exception {
        this.properties = properties;
        this.launchOSGiFrameWork();
        return this.getRuntime();
    }

    public boolean handles(Constants.Platform platform) {
        switch (platform) {
            case Felix: 
            case Equinox: 
            case Knopflerfish: {
                return true;
            }
        }
        return false;
    }

    public void destroy() throws Exception {
        this.framework.stop();
        this.framework.waitForStop(0L);
    }

    private GlassFishRuntime getRuntime() throws Exception {
        BundleContext context = this.framework.getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, GlassFishRuntime.class.getName(), null);
        tracker.open(true);
        return (GlassFishRuntime)GlassFishRuntime.class.cast(tracker.waitForService(0L));
    }

    protected void launchOSGiFrameWork() throws Exception {
        if (!this.isOSGiEnv()) {
            ServiceLoader<FrameworkFactory> frameworkFactories = ServiceLoader.load(FrameworkFactory.class, this.getClass().getClassLoader());
            for (FrameworkFactory ff : frameworkFactories) {
                this.framework = ff.newFramework((Map)this.properties);
            }
            if (this.framework == null) {
                throw new RuntimeException("No OSGi framework in classpath");
            }
            this.framework.init();
            OSGiGlassFishRuntimeBuilder.debug("Initialized + " + this.framework);
            AutoProcessor.process(this.properties, this.framework.getBundleContext());
            this.framework.start();
        }
    }

    private boolean isOSGiEnv() {
        return this.getClass().getClassLoader() instanceof BundleReference;
    }

    private static void debug(String s) {
        System.out.println("OSGiGlassFishRuntime: " + s);
    }
}

