/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.dom.HttpRedirect;
import com.sun.grizzly.http.portunif.HttpRedirector;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class HttpRedirectFilter
implements ProtocolFilter,
ConfigAwareElement {
    private Integer redirectPort;
    private Boolean secure;

    public boolean execute(Context ctx) throws IOException {
        boolean redirectToSecure;
        WorkerThread thread = (WorkerThread)Thread.currentThread();
        SSLEngine sslEngine = thread.getSSLEngine();
        if (this.secure != null) {
            redirectToSecure = this.secure;
        } else {
            boolean bl = redirectToSecure = sslEngine == null;
        }
        if (sslEngine != null) {
            HttpRedirector.redirectSSL((Context)ctx, (SSLEngine)sslEngine, (ByteBuffer)thread.getByteBuffer(), (ByteBuffer)thread.getOutputBB(), (Integer)this.redirectPort, (boolean)redirectToSecure);
        } else {
            HttpRedirector.redirect((Context)ctx, (ByteBuffer)thread.getByteBuffer(), (Integer)this.redirectPort, (boolean)redirectToSecure);
        }
        return true;
    }

    public boolean postExecute(Context ctx) throws IOException {
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        return true;
    }

    public void configure(ConfigBeanProxy configuration) {
        if (configuration instanceof HttpRedirect) {
            HttpRedirect httpRedirectConfig = (HttpRedirect)configuration;
            int port = Integer.parseInt(httpRedirectConfig.getPort());
            this.redirectPort = port != -1 ? Integer.valueOf(port) : null;
            this.secure = Boolean.parseBoolean(httpRedirectConfig.getSecure());
        }
    }
}

