/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.util.logging.Logger;

public abstract class HandShake {
    static final Logger logger = Logger.getLogger("websocket");
    private boolean secure;
    private String origin;
    private String serverHostName;
    private String port = "80";
    private String resourcePath;
    private String location;
    private String subProtocol;

    public HandShake(boolean isSecure, String path) {
        this.secure = isSecure;
        this.resourcePath = path;
    }

    public HandShake(boolean isSecure, String origin, String serverHostName, String portNumber, String resourcePath) {
        this.origin = origin;
        this.serverHostName = serverHostName;
        this.secure = isSecure;
        this.port = portNumber;
        this.resourcePath = resourcePath;
        this.subProtocol = null;
        this.location = this.buildLocation(isSecure);
    }

    String buildLocation(boolean isSecure) {
        StringBuilder builder = new StringBuilder((isSecure ? "wss" : "ws") + "://" + this.serverHostName);
        if (!"80".equals(this.port)) {
            builder.append(":" + this.port);
        }
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        return builder.toString();
    }

    final String readHeader(MimeHeaders headers, String name) {
        MessageBytes value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }
}

