/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.component.Habitat;

public class LogFilterForInstance {
    public File getInstanceLogFile(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName) {
        File instanceLogFile = null;
        try {
            int i;
            SSHLauncher sshL = (SSHLauncher)habitat.getComponent(SSHLauncher.class);
            String sNode = targetServer.getNode();
            Nodes nodes = domain.getNodes();
            Node node = nodes.getNode(sNode);
            sshL.init(node, logger);
            SFTPClient sftpClient = sshL.getSFTPClient();
            File tempFile = File.createTempFile("instance", "log");
            tempFile.delete();
            tempFile.mkdirs();
            instanceLogFile = new File(tempFile.getAbsolutePath() + File.separator + instanceName + ".log");
            InputStream inputStream = sftpClient.read(node.getInstallDir() + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator + "server.log");
            BufferedInputStream in = new BufferedInputStream(inputStream);
            FileOutputStream file = new FileOutputStream(instanceLogFile);
            BufferedOutputStream out = new BufferedOutputStream(file);
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "logging.backend.error.instance", ex);
            throw new RuntimeException(ex);
        }
        return instanceLogFile;
    }
}

