/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.GlassFishMain;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();

    public static void main(String[] args) throws Exception {
        ASMainHelper.checkJdkVersion();
        String platform = ASMainHelper.whichPlatform();
        if (ASMainHelper.isOSGiPlatform(platform)) {
            GlassFishMain.main(args);
            return;
        }
        File installRoot = ASMainHelper.findInstallRoot();
        File instanceRoot = ASMainHelper.findInstanceRoot(installRoot, args);
        Properties ctx = ASMainHelper.buildStartupContext(platform, installRoot, instanceRoot, args);
        ASMainHelper.setSystemProperties(ctx);
        PlatformMain delegate = ASMainHelper.getMain(platform);
        if (delegate != null) {
            logger.info("Launching GlassFish on " + platform + " platform");
            logger.fine("Startup Context: " + ctx);
            try {
                delegate.setLogger(logger);
                delegate.start(ctx);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            logger.severe("Cannot launch GlassFish on the unknown " + platform + " platform");
        }
    }
}

