/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.StartupContextUtil;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ASMainHelper {
    private static Logger logger = Logger.getLogger(ASMainHelper.class.getPackage().getName());

    ASMainHelper() {
    }

    static void checkJdkVersion() {
        int minor = ASMainHelper.getMinorJdkVersion();
        if (minor < 6) {
            logger.severe("GlassFish requires JDK 6, you are using JDK version " + minor);
            System.exit(1);
        }
    }

    private static int getMinorJdkVersion() {
        try {
            String jv = System.getProperty("java.version");
            String[] ss = jv.split("\\.");
            if (ss == null || ss.length < 3 || !ss[0].equals("1")) {
                return 1;
            }
            return Integer.parseInt(ss[1]);
        }
        catch (Exception e) {
            return 1;
        }
    }

    static String whichPlatform() {
        String platform = Constants.Platform.Felix.toString();
        String temp = System.getProperty("GlassFish_Platform");
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv("GlassFish_Platform");
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = temp.trim();
        }
        return platform;
    }

    static PlatformMain getMain(String platform) {
        ServiceLoader<PlatformMain> loader = ServiceLoader.load(PlatformMain.class, ASMain.class.getClassLoader());
        for (PlatformMain main : loader) {
            if (!main.getName().equalsIgnoreCase(platform)) continue;
            return main;
        }
        return null;
    }

    static Properties parseAsEnv(File installRoot) {
        Properties asenvProps = new Properties();
        File configDir = new File(installRoot, "config");
        File asenv = ASMainHelper.getAsEnvConf(configDir);
        if (!asenv.exists()) {
            logger.fine(asenv.getAbsolutePath() + " not found, ignoring");
            return asenvProps;
        }
        BufferedReader lnReader = null;
        try {
            lnReader = new LineNumberReader(new FileReader(asenv));
            String line = ((LineNumberReader)lnReader).readLine();
            Pattern p = Pattern.compile("[Ss]?[Ee]?[Tt]? *([^=]*)=\"?([^\"]*)\"?");
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    File f = new File(m.group(2));
                    if (!f.isAbsolute()) {
                        f = new File(configDir, m.group(2));
                        if (f.exists()) {
                            asenvProps.put(m.group(1), f.getAbsolutePath());
                        } else {
                            asenvProps.put(m.group(1), m.group(2));
                        }
                    } else {
                        asenvProps.put(m.group(1), m.group(2));
                    }
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf : ", ioe);
        }
        finally {
            try {
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (IOException ioe) {}
        }
        return asenvProps;
    }

    void addPaths(File dir, String[] jarPrefixes, List<URL> urls) throws MalformedURLException {
        File[] jars = dir.listFiles();
        if (jars != null) {
            for (File f : jars) {
                for (String prefix : jarPrefixes) {
                    String name = f.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(".jar")) continue;
                    urls.add(f.toURI().toURL());
                }
            }
        }
    }

    private static File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1) {
            return new File(configDir, "asenv.conf");
        }
        return new File(configDir, "asenv.bat");
    }

    static File getDomainRoot(Properties args, Properties asEnv) {
        String domainDir = ASMainHelper.getParam(args, "domaindir");
        if (ASMainHelper.ok(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = ASMainHelper.getDefaultDomainsDir(asEnv);
        String domainName = ASMainHelper.getParam(args, "domain");
        if (ASMainHelper.ok(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return ASMainHelper.getDefaultDomain(defDomainsRoot);
    }

    void verifyAndSetDomainRoot(File domainRoot) {
        ASMainHelper.verifyDomainRoot(domainRoot);
        domainRoot = ASMainHelper.absolutize(domainRoot);
        System.setProperty("com.sun.aas.instanceRoot", domainRoot.getPath());
    }

    static void verifyDomainRoot(File domainRoot) {
        String msg = null;
        if (domainRoot == null) {
            msg = "Internal Error: The domain dir is null.";
        } else if (!domainRoot.exists()) {
            msg = "the domain directory does not exist";
        } else if (!domainRoot.isDirectory()) {
            msg = "the domain directory is not a directory.";
        } else if (!domainRoot.canWrite()) {
            msg = "the domain directory is not writable.";
        } else if (!new File(domainRoot, "config").isDirectory()) {
            msg = "the domain directory is corrupt - there is no config subdirectory.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
    }

    private static File getDefaultDomainsDir(Properties asEnv) {
        String dirname = asEnv.getProperty("AS_DEF_DOMAINS_PATH");
        if (!ASMainHelper.ok(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = ASMainHelper.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "]" + " is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private static File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("Multiple domains[" + domains.length + "] found under " + domainsDir + " -- you must specify a domain name as -domain <name>");
        }
        return domains[0];
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static String getParam(Properties map, String name) {
        String val = map.getProperty("-" + name);
        if (val == null) {
            val = map.getProperty("--" + name);
        }
        return val;
    }

    private static File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    static File getInstanceRoot(Properties args, Properties asEnv) {
        String instanceDir = ASMainHelper.getParam(args, "instancedir");
        if (ASMainHelper.ok(instanceDir)) {
            return new File(instanceDir);
        }
        return null;
    }

    static File findInstallRoot() {
        File bootstrapFile = ASMainHelper.findBootstrapFile();
        return bootstrapFile.getParentFile().getParentFile();
    }

    static File findInstanceRoot(File installRoot, Properties args) {
        Properties asEnv = ASMainHelper.parseAsEnv(installRoot);
        File instanceDir = ASMainHelper.getInstanceRoot(args, asEnv);
        if (instanceDir == null) {
            instanceDir = ASMainHelper.getDomainRoot(args, asEnv);
        }
        ASMainHelper.verifyDomainRoot(instanceDir);
        return instanceDir;
    }

    static File findInstanceRoot(File installRoot, String[] args) {
        return ASMainHelper.findInstanceRoot(installRoot, ArgumentManager.argsToMap((String[])args));
    }

    private static File findBootstrapFile() {
        try {
            return Which.jarFile(ASMain.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + ASMain.class + " class location, aborting");
        }
    }

    static Properties buildStartupContext(String platform, File installRoot, File instanceRoot, String[] args) {
        Properties ctx = ArgumentManager.argsToMap((String[])args);
        ctx.setProperty("__time_zero", new Long(System.currentTimeMillis()).toString());
        ctx.setProperty("GlassFish_Platform", platform);
        ctx.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        ctx.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        ctx.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        ctx.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        if (ctx.getProperty("hk2.startup.context.mainModule") == null) {
            ctx.setProperty("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-upgrade") || i + 1 >= args.length || args[i + 1].equals("false")) continue;
            ctx.setProperty("hk2.startup.context.moduleStartup", "upgrade");
        }
        ASMainHelper.addRawStartupInfo(args, ctx);
        ASMainHelper.mergePlatformConfiguration(ctx);
        return ctx;
    }

    static void buildStartupContext(Properties ctx) {
        File installRoot;
        if (ctx.getProperty("__time_zero") != null) {
            return;
        }
        ctx.setProperty("__time_zero", new Long(System.currentTimeMillis()).toString());
        if (ctx.getProperty("GlassFish_Platform") == null) {
            ctx.setProperty("GlassFish_Platform", Constants.Platform.Felix.name());
        }
        if (ctx.getProperty("com.sun.aas.installRoot") == null) {
            installRoot = ASMainHelper.findInstallRoot();
            ctx.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            ctx.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if (ctx.getProperty("com.sun.aas.instanceRoot") == null) {
            installRoot = new File(ctx.getProperty("com.sun.aas.installRoot"));
            File instanceRoot = ASMainHelper.findInstanceRoot(installRoot, ctx);
            ctx.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            ctx.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
        if (ctx.getProperty("hk2.startup.context.mainModule") == null) {
            ctx.setProperty("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        }
        ASMainHelper.mergePlatformConfiguration(ctx);
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        if (!ASMainHelper.wasStartedByCLI(p)) {
            p.put("-startup-classpath", System.getProperty("java.class.path"));
            p.put("-startup-classname", ASMain.class.getName());
            p.put("-startup-args", sb.toString());
        }
    }

    private static boolean wasStartedByCLI(Properties props) {
        return props.getProperty("-asadmin-classpath") != null && props.getProperty("-asadmin-classname") != null && props.getProperty("-asadmin-args") != null;
    }

    static ClassLoader createLauncherCL(Properties ctx, ClassLoader delegate) {
        try {
            ClassLoaderBuilder clb = new ClassLoaderBuilder(ctx, delegate);
            clb.addLauncherJar();
            clb.addFrameworkJars();
            clb.addJDKToolsJar();
            clb.findDerbyClient();
            return clb.build();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    static void setSystemProperties(Properties ctx) {
        System.setProperty("GlassFish_Platform", ctx.getProperty("GlassFish_Platform"));
    }

    static void mergePlatformConfiguration(Properties ctx) {
        Properties platformConf = null;
        try {
            platformConf = PlatformHelper.getPlatformHelper(ctx).readPlatformConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        platformConf.putAll((Map<?, ?>)ctx);
        Util.substVars(platformConf);
        ctx.clear();
        ctx.putAll((Map<?, ?>)platformConf);
    }

    static boolean isOSGiPlatform(String platform) {
        Constants.Platform p = Constants.Platform.valueOf(platform);
        switch (p) {
            case Felix: 
            case Knopflerfish: 
            case Equinox: {
                return true;
            }
        }
        return false;
    }

    static class StaticHelper
    extends PlatformHelper {
        StaticHelper() {
        }

        protected void setFwDir() {
        }

        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
        }

        protected File getFrameworkConfigFile() {
            return null;
        }
    }

    static class KnopflerfishHelper
    extends PlatformHelper {
        private static final String KF_HOME = "KNOPFLERFISH_HOME";
        public static final String GF_KF_HOME = "osgi/knopflerfish.org/osgi/";
        public static final String CONFIG_PROPERTIES = "conf/config.properties";

        KnopflerfishHelper() {
        }

        protected void setFwDir() {
            String fwPath = System.getenv(KF_HOME);
            if (fwPath == null) {
                fwPath = new File(this.glassfishDir, GF_KF_HOME).getAbsolutePath();
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate KnopflerFish at " + fwPath);
            }
        }

        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            cpb.addJar(new File(this.fwDir, "framework.jar"));
        }

        protected File getFrameworkConfigFile() {
            return new File(this.fwDir, CONFIG_PROPERTIES);
        }
    }

    static class EquinoxHelper
    extends PlatformHelper {
        private static File pluginsDir = null;

        EquinoxHelper() {
        }

        protected void setFwDir() {
            String fwPath = System.getenv("EQUINOX_HOME");
            if (fwPath == null) {
                fwPath = new File(this.glassfishDir, "osgi/equinox").getAbsolutePath();
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                this.fwDir = new File(this.glassfishDir, "osgi/eclipse");
            }
            if (this.fwDir.exists() && !(pluginsDir = new File(this.fwDir, "plugins")).exists()) {
                pluginsDir = null;
            }
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate Equinox at " + fwPath);
            }
        }

        protected File getFrameworkConfigFile() {
            return new File(this.fwDir, "configuration/config.ini");
        }

        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            if (pluginsDir != null) {
                cpb.addGlob(pluginsDir, "org.eclipse.osgi_*.jar");
            } else {
                cpb.addJarFolder(this.fwDir, new String[0]);
            }
        }
    }

    static class FelixHelper
    extends PlatformHelper {
        private static final String FELIX_HOME = "FELIX_HOME";
        public static final String GF_FELIX_HOME = "osgi/felix";
        public static final String CONFIG_PROPERTIES = "conf/config.properties";

        FelixHelper() {
        }

        protected void setFwDir() {
            String fwPath = System.getenv(FELIX_HOME);
            if (fwPath == null) {
                fwPath = System.getProperty(FELIX_HOME, new File(this.glassfishDir, GF_FELIX_HOME).getAbsolutePath());
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate Felix at " + fwPath);
            }
        }

        protected File getFrameworkConfigFile() {
            File jaxb = new File(this.glassfishDir, "modules/jaxb-osgi.jar");
            String fileName = jaxb.exists() ? "conf/config.properties.nojaxb" : CONFIG_PROPERTIES;
            return new File(this.fwDir, fileName);
        }

        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            cpb.addJar(new File(this.fwDir, "bin/felix.jar"));
        }
    }

    static abstract class PlatformHelper {
        protected Properties properties;
        protected File glassfishDir;
        protected File fwDir;

        PlatformHelper() {
        }

        static synchronized PlatformHelper getPlatformHelper(Properties properties) {
            PlatformHelper platformHelper;
            Constants.Platform platform = Constants.Platform.valueOf(properties.getProperty("GlassFish_Platform"));
            switch (platform) {
                case Felix: {
                    platformHelper = new FelixHelper();
                    break;
                }
                case Knopflerfish: {
                    platformHelper = new KnopflerfishHelper();
                    break;
                }
                case Equinox: {
                    platformHelper = new EquinoxHelper();
                    break;
                }
                case Static: {
                    platformHelper = new StaticHelper();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported platform " + (Object)((Object)platform));
                }
            }
            platformHelper.init(properties);
            return platformHelper;
        }

        void init(Properties properties) {
            this.properties = properties;
            this.glassfishDir = StartupContextUtil.getInstallRoot(properties);
            this.setFwDir();
        }

        protected abstract void setFwDir();

        protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Properties readPlatformConfiguration() throws IOException {
            Properties platformConfig = new Properties();
            File configFile = this.getFrameworkConfigFile();
            if (configFile == null) {
                return platformConfig;
            }
            FileInputStream in = new FileInputStream(configFile);
            try {
                platformConfig.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            return platformConfig;
        }

        protected abstract File getFrameworkConfigFile();
    }

    static class ClassLoaderBuilder {
        protected ClassPathBuilder cpb;
        protected File glassfishDir;
        protected Properties ctx;

        ClassLoaderBuilder(Properties ctx, ClassLoader delegate) {
            this.ctx = ctx;
            this.cpb = new ClassPathBuilder(delegate);
            this.glassfishDir = new File(ctx.getProperty("com.sun.aas.installRoot"));
        }

        void addFrameworkJars() throws IOException {
            PlatformHelper.getPlatformHelper(this.ctx).addFrameworkJars(this.cpb);
        }

        void addJDKToolsJar() {
            try {
                File jdkToolsJar = Util.getJDKToolsJar();
                if (jdkToolsJar.exists()) {
                    this.cpb.addJar(jdkToolsJar);
                } else {
                    logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        void findDerbyClient() throws IOException {
            String derbyHome = ASMainHelper.parseAsEnv(this.glassfishDir).getProperty("AS_DERBY_INSTALL");
            File derbyLib = null;
            if (derbyHome != null) {
                derbyLib = new File(derbyHome, "lib");
            }
            if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
                File jdkHome = new File(System.getProperty("java.home"));
                derbyLib = new File(jdkHome, "../db/lib");
            }
            if (!derbyLib.exists()) {
                logger.info("Cannot find javadb client jar file, jdbc driver not available");
                return;
            }
            this.cpb.addGlob(derbyLib, "derby*.jar");
        }

        public ClassLoader build() {
            return this.cpb.create();
        }

        public void addLauncherJar() throws IOException {
            this.cpb.addJar(new File(this.glassfishDir, "modules/glassfish.jar"));
        }
    }
}

