/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface LoadBalancer
extends ConfigBeanProxy,
Injectable,
PropertyBag {
    @Attribute(key=true)
    @NotNull
    public String getName();

    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getLbConfigName();

    public void setLbConfigName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getDeviceHost();

    public void setDeviceHost(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getDevicePort();

    public void setDevicePort(String var1) throws PropertyVetoException;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<LoadBalancers, LoadBalancer> {
        @Inject
        private Domain domain;

        @Override
        public void decorate(AdminCommandContext context, LoadBalancers parent, LoadBalancer child) throws PropertyVetoException, TransactionFailure {
            ActionReport report = context.getActionReport();
            Logger logger = LogDomains.getLogger(LoadBalancer.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoadBalancer.class);
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)parent);
            String lbName = child.getName();
            String lbConfigName = child.getLbConfigName();
            LbConfig lbConfig = this.domain.getLbConfigs().getLbConfig(lbConfigName);
            for (LoadBalancer lb : this.domain.getLoadBalancers().getLoadBalancer()) {
                if (lb.getName().equals(lbName) || !lb.getLbConfigName().equals(lbConfigName)) continue;
                String msg = localStrings.getLocalString("LbConfigIsInUse", lbConfigName);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                throw new TransactionFailure(msg);
            }
            LbConfigs configs = this.domain.getLbConfigs();
            try {
                if (t != null) {
                    LbConfigs c = (LbConfigs)t.enroll((ConfigBeanProxy)configs);
                    List<LbConfig> configList = c.getLbConfig();
                    configList.remove(lbConfig);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.WARNING, localStrings.getLocalString("DeleteLbConfigFailed", "Unable to remove lb config {0}", new Object[]{lbConfigName}), ex);
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("DeleteLbConfigFailed", "Unable to remove lb config {0}", new Object[]{lbConfigName});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                throw ex;
            }
        }
    }
}

