/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class ServerHelper {
    private final Server server;
    private final Config config;

    public ServerHelper(Server theServer, Config theConfig) {
        this.server = theServer;
        this.config = theConfig;
        if (this.server == null || this.config == null) {
            throw new IllegalArgumentException();
        }
    }

    public final int getAdminPort() {
        try {
            if (this.server == null) {
                return -1;
            }
            if (this.config == null) {
                return -1;
            }
            String portString = ServerHelper.getAdminPortString(this.server, this.config);
            if (portString == null) {
                return -1;
            }
            return Integer.parseInt(portString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public final String getAdminHost() {
        if (this.server == null || this.config == null) {
            return null;
        }
        NetworkListener nl = ServerHelper.getAdminListener(this.config);
        String addr = nl.getAddress();
        if (addr != null && !addr.equals("0.0.0.0")) {
            return addr;
        }
        if (this.server.isDas()) {
            return null;
        }
        String hostName = null;
        Dom serverDom = Dom.unwrap((ConfigBeanProxy)this.server);
        Nodes nodes = (Nodes)serverDom.getHabitat().getComponent(Nodes.class);
        String nodeName = this.server.getNode();
        if (StringUtils.ok((String)nodeName)) {
            Node node = nodes.getNode(nodeName);
            if (node != null) {
                hostName = node.getNodeHost();
            }
            if (hostName == null && nodeName.equals("localhost")) {
                hostName = "localhost";
            }
        }
        if (StringUtils.ok(hostName)) {
            return hostName;
        }
        return null;
    }

    public final boolean isRunning() {
        try {
            return NetUtils.isRunning((String)this.getAdminHost(), (int)this.getAdminPort());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static NetworkListener getAdminListener(Config config) {
        NetworkConfig nwc = config.getNetworkConfig();
        if (nwc == null) {
            throw new IllegalStateException("Can't operate without <http-service>");
        }
        List lss = nwc.getNetworkListeners().getNetworkListener();
        if (lss == null || lss.isEmpty()) {
            throw new IllegalStateException("Can't operate without at least one <network-listener>");
        }
        for (NetworkListener ls : lss) {
            if (!"admin-listener".equals(ls.getName())) continue;
            return ls;
        }
        return (NetworkListener)lss.get(0);
    }

    private static String getAdminPortString(Server server, Config config) {
        if (server == null || config == null) {
            return null;
        }
        return ServerHelper.translatePort(ServerHelper.getAdminListener(config), server, config);
    }

    private static String translatePort(NetworkListener adminListener, Server server, Config config) {
        NetworkListener adminListenerRaw = null;
        try {
            Dom serverDom = Dom.unwrap((ConfigBeanProxy)server);
            Domain domain = (Domain)serverDom.getHabitat().getComponent(Domain.class);
            adminListenerRaw = GlassFishConfigBean.getRawView(adminListener);
            String portString = adminListenerRaw.getPort();
            if (!ServerHelper.isToken(portString)) {
                return portString;
            }
            PropertyResolver resolver = new PropertyResolver(domain, server.getName());
            return resolver.getPropertyValue(portString);
        }
        catch (ClassCastException e) {
            return ServerHelper.translatePortOld(adminListener.getPort(), server, config);
        }
    }

    private static String translatePortOld(String portString, Server server, Config config) {
        if (!ServerHelper.isToken(portString)) {
            return portString;
        }
        String key = portString.substring(2, portString.length() - 1);
        SystemProperty prop = server.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        prop = config.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    private static boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }
}

