/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWebSocket
implements WebSocket {
    private final NetworkHandler networkHandler;
    protected static final Logger logger = Logger.getLogger("websocket");
    private final List<WebSocketListener> listeners = new ArrayList<WebSocketListener>();
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public BaseWebSocket(NetworkHandler handler, WebSocketListener ... listeners) {
        this.networkHandler = handler;
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
        handler.setWebSocket(this);
    }

    public NetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    public List<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            try {
                this.send(new DataFrame(FrameType.CLOSING));
            }
            catch (IOException iOException) {
            }
            finally {
                this.onClose();
            }
        }
    }

    @Override
    public void onClose() throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onClose(this);
        }
        this.listeners.clear();
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void send(String data) throws IOException {
        this.send(new DataFrame(data));
    }

    @Override
    public void send(DataFrame frame) throws IOException {
        this.networkHandler.send(frame);
    }

    @Override
    public void onConnect() throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.connected.compareAndSet(false, true);
    }

    @Override
    public void onMessage(DataFrame frame) throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage(this, frame);
        }
    }
}

