/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-profiler")
@Scoped(value=PerLookup.class)
@I18n(value="delete.profiler")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteProfiler
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProfiler.class);
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetService;
    @Inject(name="default-instance-name")
    Config config;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        Config targetConfig = this.targetService.getConfig(this.target);
        if (targetConfig != null) {
            this.config = targetConfig;
        }
        JavaConfig javaConfig = this.config.getJavaConfig();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

                public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                    if (param.getProfiler() != null) {
                        param.setProfiler(null);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return param;
                    }
                    report.setMessage(localStrings.getLocalString("delete.profiler.notfound", "delete failed, profiler not found"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
            }, (ConfigBeanProxy)javaConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.profiler.fail", "delete failed "));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

