/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.ConnectException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Inject;

public class InstanceCommandExecutor
extends RemoteAdminCommand
implements Runnable,
InstanceCommand {
    @Inject
    Domain domain;
    private Server server;
    private ParameterMap params;
    private ActionReport aReport;
    private String commandName;
    private FailurePolicy offlinePolicy;
    private FailurePolicy failPolicy;
    private InstanceCommandResult result;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(InstanceCommandExecutor.class);

    public InstanceCommandExecutor(String name, FailurePolicy fail, FailurePolicy offline, Server server, String host, int port, Logger logger, ParameterMap p, ActionReport r, InstanceCommandResult res) throws CommandException {
        super(name, host, port, false, "admin", "", logger);
        this.server = server;
        this.params = p;
        this.aReport = r;
        this.commandName = name;
        this.offlinePolicy = offline;
        this.failPolicy = fail;
        this.result = res;
    }

    public String getCommandOutput() {
        return this.output;
    }

    public Server getServer() {
        return this.server;
    }

    public ActionReport getReport() {
        return this.aReport;
    }

    public void run() {
        try {
            this.executeCommand(this.params);
            this.aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            if (StringUtils.ok(this.getCommandOutput())) {
                this.aReport.setMessage(this.getServer().getName() + " :\n" + this.getCommandOutput() + "\n\n");
            }
        }
        catch (CommandException cmdEx) {
            ActionReport.ExitCode finalResult;
            if (cmdEx.getCause() instanceof ConnectException) {
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)this.offlinePolicy, (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.warnoffline", "WARNING : Instance {0} seems to be offline; Command was not replicated to that instance", this.getServer().getName()));
                }
            } else {
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)this.failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command {0} failed on server instance {1} : {2}", this.commandName, this.getServer().getName(), cmdEx.getMessage()));
                } else {
                    this.aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandWarning", "WARNING : Command {0} did not complete successfully on server instance {1} : {2}", this.commandName, this.getServer().getName(), cmdEx.getMessage()));
                }
            }
            this.aReport.setActionExitCode(finalResult);
        }
        this.result.setInstanceCommand((InstanceCommand)this);
    }
}

