/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.glassfish.experimentalgfapi.Constants;
import org.glassfish.experimentalgfapi.GlassFishRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedOSGiGlassFishRuntimeBuilder
implements GlassFishRuntime.RuntimeBuilder {
    private BundleContext bundleContext;
    private String installRoot;
    private static final String mainBundleName = "org.glassfish.core.kernel";
    static final String BUILDER_NAME_PROPERTY = "GlassFish.BUILDER_NAME";
    private static final String JAR_EXT = ".jar";

    @Override
    public boolean handles(Properties properties) {
        return EmbeddedOSGiGlassFishRuntimeBuilder.class.getName().equals(properties.getProperty(BUILDER_NAME_PROPERTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlassFishRuntime build(Properties properties) throws Exception {
        this.bundleContext = this.getBundleContext();
        this.installRoot = properties.getProperty("com.sun.aas.installRoot");
        this.installBundles();
        this.configureBundles();
        this.startBundles();
        ServiceTracker st = new ServiceTracker(this.bundleContext, GlassFishRuntime.class.getName(), null);
        try {
            st.open();
            GlassFishRuntime glassFishRuntime = (GlassFishRuntime)GlassFishRuntime.class.cast(st.waitForService(0L));
            return glassFishRuntime;
        }
        finally {
            st.close();
        }
    }

    private void configureBundles() {
        System.setProperty("GlassFish_Platform", Constants.Platform.GenericOSGi.toString());
    }

    private void installBundles() {
        for (File jar : this.findJars()) {
            try {
                this.bundleContext.installBundle(jar.toURI().toString());
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    private List<File> findJars() {
        File modulesDir = new File(this.installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<File> jars = new ArrayList<File>();
        modulesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(EmbeddedOSGiGlassFishRuntimeBuilder.JAR_EXT)) {
                    jars.add(pathname);
                }
                return false;
            }
        });
        return jars;
    }

    private void startBundles() {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!mainBundleName.equals(b.getSymbolicName())) continue;
            try {
                b.start(1);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() throws Exception {
    }

    private BundleContext getBundleContext() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
    }
}

