/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.DynamicConfigListener;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class GrizzlyService
implements Startup,
RequestDispatcher,
PostConstruct,
PreDestroy,
FutureProvider<Result<Thread>> {
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ProbeProviderFactory probeProviderFactory;
    private final Collection<NetworkProxy> proxies = new LinkedBlockingQueue<NetworkProxy>();
    List<Future<Result<Thread>>> futures;
    Collection<String> hosts = new ArrayList<String>();
    private final GrizzlyMonitoring monitoring;
    private static final String NETWORK_CONFIG_PREFIX = "";
    private final ConcurrentLinkedQueue<MapperUpdateListener> mapperUpdateListeners = new ConcurrentLinkedQueue();
    private DynamicConfigListener configListener;

    public GrizzlyService() {
        this.futures = new ArrayList<Future<Result<Thread>>>();
        this.monitoring = new GrizzlyMonitoring();
    }

    public void addNetworkProxy(NetworkProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean removeNetworkProxy(NetworkListener listener) {
        return this.removeNetworkProxy(this.lookupNetworkProxy(listener));
    }

    public boolean removeNetworkProxy(String id) {
        NetworkProxy proxy = null;
        for (NetworkProxy p : this.proxies) {
            if (!(p instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)p;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(id)) continue;
            proxy = p;
            break;
        }
        return this.removeNetworkProxy(proxy);
    }

    public boolean removeNetworkProxy(NetworkProxy proxy) {
        if (proxy != null) {
            proxy.stop();
            proxy.destroy();
            this.proxies.remove(proxy);
            return true;
        }
        return false;
    }

    public NetworkProxy lookupNetworkProxy(NetworkListener listener) {
        InetAddress address;
        int listenerPort;
        block8: {
            block7: {
                listenerPort = -1;
                address = null;
                try {
                    listenerPort = Integer.parseInt(listener.getPort());
                }
                catch (NumberFormatException e) {
                    if (!this.logger.isLoggable(Level.FINE)) break block7;
                    this.logger.log(Level.FINE, e.toString());
                }
            }
            try {
                address = InetAddress.getByName(listener.getAddress());
            }
            catch (UnknownHostException uhe) {
                if (!this.logger.isLoggable(Level.FINE)) break block8;
                this.logger.log(Level.FINE, uhe.toString());
            }
        }
        if (listenerPort != -1) {
            for (NetworkProxy p : this.proxies) {
                if (p.getPort() != listenerPort || !p.getAddress().equals(address)) continue;
                return p;
            }
        }
        String listenerId = listener.getName();
        for (NetworkProxy p : this.proxies) {
            if (!(p instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)p;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(listenerId)) continue;
            return p;
        }
        return null;
    }

    public boolean hasMapperUpdateListener() {
        return !this.mapperUpdateListeners.isEmpty();
    }

    public boolean addMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.add(listener);
    }

    public boolean removeMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.remove(listener);
    }

    public void notifyMapperUpdateListeners(NetworkListener networkListener, Mapper mapper) {
        HttpService httpService = this.config.getHttpService();
        for (MapperUpdateListener listener : this.mapperUpdateListeners) {
            listener.update(httpService, networkListener, mapper);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public GrizzlyMonitoring getMonitoring() {
        return this.monitoring;
    }

    @Override
    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        this.configListener = new DynamicConfigListener();
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)networkConfig.getNetworkListeners());
        bean.addListener((ConfigListener)this.configListener);
        bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.config.getHttpService());
        bean.addListener((ConfigListener)this.configListener);
        this.configListener.setGrizzlyService(this);
        this.configListener.setLogger(this.logger);
        try {
            JmsService jmsService;
            this.futures = new ArrayList<Future<Result<Thread>>>();
            for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
                this.createNetworkProxy(listener);
            }
            IiopService iiopService = this.config.getIiopService();
            if (iiopService != null) {
                List iiopListenerList = iiopService.getIiopListener();
                for (IiopListener oneListener : iiopListenerList) {
                    if (!Boolean.valueOf(oneListener.getEnabled()).booleanValue() || !Boolean.valueOf(oneListener.getLazyInit()).booleanValue()) continue;
                    DummyNetworkListener dummy = new DummyNetworkListener();
                    dummy.setPort(oneListener.getPort());
                    dummy.setAddress(oneListener.getAddress());
                    dummy.setProtocol("light-weight-listener");
                    dummy.setTransport("tcp");
                    dummy.setName("iiop-service");
                    this.createNetworkProxy(dummy);
                }
            }
            if ((jmsService = this.config.getJmsService()) != null && "EMBEDDED".equalsIgnoreCase(jmsService.getType())) {
                List jmsHosts = jmsService.getJmsHost();
                for (JmsHost oneHost : jmsHosts) {
                    if (!Boolean.valueOf(oneHost.getLazyInit()).booleanValue()) continue;
                    DummyNetworkListener dummy = new DummyNetworkListener();
                    dummy.setPort(oneHost.getPort());
                    dummy.setAddress(oneHost.getHost());
                    dummy.setProtocol("light-weight-listener");
                    dummy.setTransport("tcp");
                    dummy.setName("mq-service");
                    this.createNetworkProxy(dummy);
                }
            }
            this.registerNetworkProxy();
        }
        catch (RuntimeException e) {
            this.logger.log(Level.SEVERE, "Unable to start v3. Closing all ports", e);
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    this.logger.log(Level.SEVERE, "Exception closing port: " + proxy.getPort(), proxyStopException);
                }
            }
            throw e;
        }
        this.registerMonitoringStatsProviders();
    }

    @Override
    public List<Future<Result<Thread>>> getFutures() {
        return this.futures;
    }

    public synchronized Future<Result<Thread>> createNetworkProxy(NetworkListener listener) {
        if (ConfigBeansUtilities.toBoolean((String)listener.getJkEnabled())) {
            return null;
        }
        if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
            this.logger.info("Network listener " + listener.getName() + " on port " + listener.getPort() + " disabled per domain.xml");
            return null;
        }
        GrizzlyProxy proxy = new GrizzlyProxy(this, listener);
        if (!"light-weight-listener".equals(listener.getProtocol())) {
            NetworkConfig networkConfig = (NetworkConfig)((NetworkListeners)listener.getParent(NetworkListeners.class)).getParent(NetworkConfig.class);
            for (VirtualServer vs : ((Config)networkConfig.getParent(Config.class)).getHttpService().getVirtualServer()) {
                List vsListeners = StringUtils.parseStringList((String)vs.getNetworkListeners(), (String)" ,");
                if (vsListeners != null && !vsListeners.isEmpty() && !vsListeners.contains(listener.getName()) || this.hosts.contains(vs.getId())) continue;
                this.hosts.add(vs.getId());
            }
            this.addChangeListener((ConfigBeanProxy)listener);
            this.addChangeListener((ConfigBeanProxy)listener.findThreadPool());
            this.addChangeListener((ConfigBeanProxy)listener.findTransport());
            Protocol protocol = listener.findHttpProtocol();
            if (protocol != null) {
                this.addChangeListener((ConfigBeanProxy)protocol);
                this.addChangeListener((ConfigBeanProxy)protocol.getHttp());
                this.addChangeListener((ConfigBeanProxy)protocol.getHttp().getFileCache());
                this.addChangeListener((ConfigBeanProxy)protocol.getSsl());
            }
        }
        Future<Result<Thread>> future = proxy.start();
        this.proxies.add(proxy);
        this.futures.add(future);
        return future;
    }

    private void addChangeListener(ConfigBeanProxy bean) {
        if (bean != null) {
            ((ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)bean)).addListener((ConfigListener)this.configListener);
        }
    }

    public void registerNetworkProxy() {
        for (org.glassfish.api.container.Adapter subAdapter : this.habitat.getAllByContract(org.glassfish.api.container.Adapter.class)) {
            try {
                if (subAdapter.isRegistered()) continue;
                this.registerAdapter(subAdapter);
                subAdapter.setRegistered(true);
            }
            catch (EndpointRegistrationException e) {
                this.logger.log(Level.WARNING, "GrizzlyService endpoint registration problem", e);
            }
        }
    }

    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            proxy.stop();
        }
        this.unregisterMonitoringStatsProviders();
    }

    @Override
    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, endpointAdapter, container, null);
    }

    @Override
    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container, String virtualServers) throws EndpointRegistrationException {
        List virtualServerList = virtualServers == null ? this.config.getHttpService().getNonAdminVirtualServerList() : StringUtils.parseStringList((String)virtualServers, (String)",");
        this.registerEndpoint(contextRoot, virtualServerList, endpointAdapter, container);
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        List<AddressInfo> addressInfos = this.getAddressInfoFromVirtualServers(vsServers);
        for (AddressInfo info : addressInfos) {
            this.registerEndpoint(contextRoot, info.address, info.port, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void registerEndpoint(String contextRoot, InetAddress address, int port, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port || !proxy.getAddress().equals(address)) continue;
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot) throws EndpointRegistrationException {
        this.unregisterEndpoint(contextRoot, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }

    protected void registerMonitoringStatsProviders() {
        this.monitoring.registerThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    protected void unregisterMonitoringStatsProviders() {
        this.monitoring.unregisterThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    private void registerAdapter(org.glassfish.api.container.Adapter a) throws EndpointRegistrationException {
        int port = a.getListenPort();
        InetAddress address = a.getListenAddress();
        List<String> vs = a.getVirtualServers();
        String cr = a.getContextRoot();
        this.registerEndpoint(cr, address, port, vs, a, null);
    }

    private List<AddressInfo> getAddressInfoFromVirtualServers(Collection<String> virtualServers) {
        ArrayList<AddressInfo> addressInfos = new ArrayList<AddressInfo>();
        List networkListenerList = this.config.getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (String vs : virtualServers) {
            VirtualServer virtualServer = this.config.getHttpService().getVirtualServerByName(vs);
            if (virtualServer == null) {
                this.logger.warning("Skip registering endpoint with non existent virtual server: " + vs);
                continue;
            }
            String vsNetworkListeners = virtualServer.getNetworkListeners();
            List vsNetworkListenerList = StringUtils.parseStringList((String)vsNetworkListeners, (String)",");
            block1: for (String vsNetworkListener : vsNetworkListenerList) {
                for (NetworkListener networkListener : networkListenerList) {
                    if (!networkListener.getName().equals(vsNetworkListener) || !Boolean.valueOf(networkListener.getEnabled()).booleanValue()) continue;
                    addressInfos.add(new AddressInfo(networkListener.getAddress(), networkListener.getPort()));
                    continue block1;
                }
            }
        }
        return addressInfos;
    }

    private static final class AddressInfo {
        private InetAddress address;
        private final int port;

        private AddressInfo(String address, String port) {
            this.port = Integer.parseInt(port);
            try {
                this.address = InetAddress.getByName(address);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static class NoopInvocationHandler
    implements InvocationHandler {
        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }
}

