/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.monitor;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="deployment-mon", group="monitoring")
@ManagedObject
@Description(value="Deployment Module Statistics")
public class DeploymentLifecycleStatsProvider {
    private static final Logger logger = LogDomains.getLogger(DeploymentLifecycleStatsProvider.class, (String)"javax.enterprise.system.tools.deployment");
    private static final String ACTIVE_APPLICATIONS_DEPLOYED_DESCRIPTION = "Number of applications deployed";
    private static final String TOTAL_APPLICATIONS_DEPLOYED_DESCRIPTION = "Total number of applications ever deployed";
    private RangeStatisticImpl activeApplicationsDeployedCount;
    private CountStatisticImpl totalApplicationsDeployedCount;

    public DeploymentLifecycleStatsProvider() {
        long curTime = System.currentTimeMillis();
        this.activeApplicationsDeployedCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveApplicationsDeployed", "count", ACTIVE_APPLICATIONS_DEPLOYED_DESCRIPTION, curTime, curTime);
        this.totalApplicationsDeployedCount = new CountStatisticImpl("TotalApplicationsDeployed", "count", TOTAL_APPLICATIONS_DEPLOYED_DESCRIPTION);
    }

    @ManagedAttribute(id="activeapplicationsdeployedcount")
    @Description(value="Number of applications deployed")
    public RangeStatistic getActiveApplicationsDeployed() {
        return this.activeApplicationsDeployedCount;
    }

    @ManagedAttribute(id="totalapplicationsdeployedcount")
    @Description(value="Total number of applications ever deployed")
    public CountStatistic getTotalApplicationsDeployed() {
        return this.totalApplicationsDeployedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:deployment:lifecycle:applicationDeployedEvent")
    public void applicationDeployedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="appType") String appType) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Application deployed event received - appName = " + appName + ": appType = " + appType);
        }
        RangeStatisticImpl rangeStatisticImpl = this.activeApplicationsDeployedCount;
        synchronized (rangeStatisticImpl) {
            this.activeApplicationsDeployedCount.setCurrent(this.activeApplicationsDeployedCount.getCurrent() + 1L);
        }
        this.totalApplicationsDeployedCount.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:deployment:lifecycle:applicationUndeployedEvent")
    public void applicationUndeployedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="appType") String appType) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Application undeployed event received - appName = " + appName + ": appType = " + appType);
        }
        RangeStatisticImpl rangeStatisticImpl = this.activeApplicationsDeployedCount;
        synchronized (rangeStatisticImpl) {
            this.activeApplicationsDeployedCount.setCurrent(this.activeApplicationsDeployedCount.getCurrent() - 1L);
        }
    }
}

