/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AsadminTrustManager;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.SecureAdminClientManager;
import com.sun.enterprise.universal.GFBase64Encoder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public final class HttpConnectorAddress {
    static final String HTTP_CONNECTOR = "http";
    static final String HTTPS_CONNECTOR = "https";
    public static final String AUTHORIZATION_KEY = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Basic ";
    private String host;
    private int port;
    private String path;
    private boolean secure;
    private AuthenticationInfo authInfo;

    public HttpConnectorAddress() {
    }

    public HttpConnectorAddress(String host, int port) {
        this(host, port, false);
    }

    public HttpConnectorAddress(String host, int port, boolean secure) {
        this(host, port, secure, null);
    }

    public HttpConnectorAddress(String host, int port, boolean secure, String path) {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.path = path;
    }

    public URLConnection openConnection(String path) throws IOException {
        this.configureSSL();
        if (path == null || path.trim().length() == 0) {
            path = this.path;
        }
        return this.openConnection(this.toURL(path));
    }

    private void configureSSL() throws IOException {
        if (this.secure) {
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                TrustManager[] tms = new TrustManager[]{new AsadminTrustManager()};
                sc.init(SecureAdminClientManager.getKeyManagers(), tms, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new BasicHostnameVerifier(this.host));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            catch (KeyManagementException ee) {
                throw new IOException(ee);
            }
        }
    }

    public String getConnectorType() {
        return this.isSecure() ? HTTPS_CONNECTOR : HTTP_CONNECTOR;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URL toURL(String path) throws MalformedURLException {
        return new URL(this.asURLSpec(path));
    }

    private final String getUser() {
        return this.authInfo != null ? this.authInfo.getUser() : "";
    }

    private final String getPassword() {
        return this.authInfo != null ? this.authInfo.getPassword() : "";
    }

    private final String asURLSpec(String path) {
        return this.getConnectorType() + "://" + this.getAuthority() + (path != null ? path : "");
    }

    private final String getAuthority() {
        return this.getHost() + ":" + this.getPort();
    }

    private final URLConnection openConnection(URL url) throws IOException {
        return this.setOptions(this.makeConnection(url));
    }

    private final URLConnection makeConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private final URLConnection setOptions(URLConnection uc) {
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("Content-type", "application/octet-stream");
        uc.setRequestProperty("Connection", "Keep-Alive");
        return this.setAuthentication(uc);
    }

    private final URLConnection setAuthentication(URLConnection uc) {
        if (this.authInfo != null) {
            uc.setRequestProperty(AUTHORIZATION_KEY, this.getBasicAuthString());
        }
        return uc;
    }

    public final String getBasicAuthString() {
        String cs = null;
        String user = this.getUser();
        String pass = this.getPassword();
        String up = user == null ? "" : user;
        String pp = pass == null ? "" : pass;
        cs = up + ":" + pp;
        String enc = this.getBase64Encoded(cs);
        enc = enc.replaceAll(System.getProperty("line.separator"), "");
        return AUTHORIZATION_TYPE + enc;
    }

    private final String getBase64Encoded(String clearString) {
        return new GFBase64Encoder().encode(clearString.getBytes());
    }

    private static class BasicHostnameVerifier
    implements HostnameVerifier {
        private final String host;

        public BasicHostnameVerifier(String host) {
            if (host == null) {
                throw new IllegalArgumentException("null host");
            }
            this.host = host;
        }

        public boolean verify(String s, SSLSession sslSession) {
            return this.host.equals(s);
        }
    }
}

