/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.StartServerCommand;
import com.sun.enterprise.admin.cli.StartServerHelper;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="start-domain")
@Scoped(value=PerLookup.class)
public class StartDomainCommand
extends LocalDomainCommand
implements StartServerCommand {
    private GFLauncherInfo info;
    private GFLauncher launcher;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);
    private StartServerHelper helper;

    public RuntimeType getType() {
        return RuntimeType.DAS;
    }

    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
    }

    protected int executeCommand() throws CommandException {
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv, this.debug);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            this.doUpgrade(mpv);
            this.launcher.launch();
            if (this.verbose || this.upgrade) {
                while (true) {
                    int returnValue = this.launcher.getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(strings.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(strings.get("restartChangeDebug", new Object[]{"on"}));
                            this.info.setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(strings.get("restartChangeDebug", new Object[]{"off"}));
                            this.info.setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
            }
            this.helper.waitForServer();
            this.helper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.launcher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.info = this.launcher.getInfo();
        this.info.setDomainName(this.getDomainName());
        this.info.setDomainParentDir(this.getDomainsDir().getPath());
        this.info.setVerbose(this.verbose || this.upgrade);
        this.info.setDebug(this.debug);
        this.info.setUpgrade(this.upgrade);
        this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.programOpts.getProgramArguments());
        this.launcher.setup();
    }

    private void debug(String s) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("startdomain.txt", true));
            ps.println(new Date().toString() + ":  " + s);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void doUpgrade(String mpv) throws GFLauncherException, MiniXmlParserException, CommandException {
        if (this.upgrade || !this.launcher.needsUpgrade()) {
            return;
        }
        logger.info(strings.get("upgradeNeeded"));
        this.info.setUpgrade(true);
        this.launcher.setup();
        this.launcher.launch();
        Process p = this.launcher.getProcess();
        int exitCode = -1;
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (exitCode != 0) {
            ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
            String output = psd.getOutErrString();
            if (StartDomainCommand.ok(output)) {
                throw new CommandException(strings.get("upgradeFailedOutput", new Object[]{this.info.getDomainName(), exitCode, output}));
            }
            throw new CommandException(strings.get("upgradeFailed", new Object[]{this.info.getDomainName(), exitCode}));
        }
        logger.info(strings.get("upgradeSuccessful"));
        this.createLauncher();
    }
}

