/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.Header;
import com.sun.enterprise.admin.remote.RemoteException;
import com.sun.enterprise.admin.remote.RemoteResponseManager;
import com.sun.enterprise.admin.remote.RemoteSuccessException;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.admin.util.SecureAdminClientManager;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteAdminCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteAdminCommand.class);
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z_][-a-zA-Z0-9_]*$";
    private static final String READ_TIMEOUT = "AS_ADMIN_READTIMEOUT";
    private static final int defaultReadTimeout;
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    protected String output;
    private Map<String, String> attrs;
    private boolean doUpload = false;
    private boolean addedUploadOption = false;
    private Payload.Outbound outboundPayload;
    private String usage;
    private File fileOutputDir;
    protected String name;
    protected String host;
    protected int port;
    protected boolean secure;
    protected String user;
    protected String password;
    protected Logger logger;
    protected ParameterMap options;
    protected List<String> operands;
    private CommandModel commandModel;
    private StringBuilder metadataErrors;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = -1;
    private List<Header> requestHeaders = new ArrayList<Header>();
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    public RemoteAdminCommand(String name, String host, int port, boolean secure, String user, String password, Logger logger) throws CommandException {
        this.name = name;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.user = user;
        this.password = password;
        this.logger = logger;
        this.checkName();
    }

    private void checkName() throws CommandException {
        if (!this.name.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandException("Illegal command name: " + this.name);
        }
    }

    public void setResponseFormatType(String responseFormatType) {
        this.responseFormatType = responseFormatType;
    }

    public void setUserOut(OutputStream userOut) {
        this.userOut = userOut;
    }

    public void setCommandModel(CommandModel commandModel) {
        this.commandModel = commandModel;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public CommandModel getCommandModel() throws CommandException {
        if (this.commandModel == null) {
            this.fetchCommandModel();
        }
        return this.commandModel;
    }

    public void setFileOutputDirectory(File dir) {
        this.fileOutputDir = dir;
    }

    public List<Header> headers() {
        return this.requestHeaders;
    }

    public String executeCommand(ParameterMap opts) throws CommandException {
        this.getCommandModel();
        this.options = opts;
        this.operands = this.options.get((Object)"DEFAULT");
        try {
            this.initializeDoUpload();
            if (this.doUpload) {
                this.outboundPayload = PayloadImpl.Outbound.newInstance();
            }
            StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
            GFBase64Encoder encoder = new GFBase64Encoder();
            CommandModel.ParamModel operandParam = null;
            for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                if (opt.getParam().primary()) {
                    operandParam = opt;
                    continue;
                }
                String paramName = opt.getName();
                String paramValue = (String)this.options.getOne((Object)paramName);
                if (paramValue == null) {
                    paramValue = this.getFromEnvironment(paramName);
                }
                if (paramValue == null) {
                    if (opt.getParam().optional()) continue;
                    throw new CommandException(strings.get("missingOption", paramName));
                }
                if (opt.getType() == File.class) {
                    this.addFileOption(uriString, paramName, paramValue);
                    continue;
                }
                if (opt.getParam().password()) {
                    this.addStringOption(uriString, paramName, encoder.encode(paramValue.getBytes()));
                    continue;
                }
                this.addStringOption(uriString, paramName, paramValue);
            }
            for (String operand : this.operands) {
                if (operandParam.getType() == File.class) {
                    this.addFileOption(uriString, "DEFAULT", operand);
                    continue;
                }
                this.addStringOption(uriString, "DEFAULT", operand);
            }
            uriString.setLength(uriString.length() - 1);
            this.executeRemoteCommand(uriString.toString());
        }
        catch (IOException ioex) {
            throw new CommandException("I/O Error", (Throwable)ioex);
        }
        return this.output;
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }

    protected boolean updateAuthentication() {
        return false;
    }

    protected String getFromEnvironment(String name) {
        return null;
    }

    protected boolean retryUsingSecureConnection(String host, int port) {
        return false;
    }

    protected String reportAuthenticationException() {
        return strings.get("InvalidCredentials", this.user);
    }

    private void executeRemoteCommand(String uri) throws CommandException {
        this.doHttpCommand(uri, this.chooseRequestMethod(), new HttpCommand(){

            public void doCommand(final HttpURLConnection urlConnection) throws CommandException, IOException {
                if (RemoteAdminCommand.this.doUpload) {
                    urlConnection.setChunkedStreamingMode(0);
                    urlConnection.setRequestProperty("Content-Type", RemoteAdminCommand.this.outboundPayload.getContentType());
                }
                for (Header h : RemoteAdminCommand.this.requestHeaders) {
                    urlConnection.addRequestProperty(h.getName(), h.getValue());
                }
                urlConnection.connect();
                if (RemoteAdminCommand.this.doUpload) {
                    RemoteAdminCommand.this.outboundPayload.writeTo(urlConnection.getOutputStream());
                    RemoteAdminCommand.this.outboundPayload = null;
                }
                RemoteAdminCommand.this.checkConnect(urlConnection);
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance(responseContentType, in);
                if (inboundPayload == null) {
                    throw new IOException(strings.get("NoPayloadSupport", responseContentType));
                }
                PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm(RemoteAdminCommand.this.fileOutputDir, null, RemoteAdminCommand.this.logger, new PayloadFilesManager.ActionReportHandler(){

                    public void handleReport(InputStream reportStream) throws Exception {
                        RemoteAdminCommand.this.handleResponse(RemoteAdminCommand.this.options, reportStream, urlConnection.getResponseCode(), RemoteAdminCommand.this.userOut);
                    }
                });
                try {
                    downloadedFilesMgr.processParts(inboundPayload);
                }
                catch (CommandException cex) {
                    throw cex;
                }
                catch (Exception ex) {
                    throw new CommandException((Throwable)ex);
                }
            }
        });
    }

    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd) throws CommandException {
        boolean shouldTryCommandAgain;
        HttpURLConnection urlConnection = null;
        boolean shouldSendCredentials = this.secure;
        boolean askedUserForCredentials = false;
        boolean shouldUseSecure = this.secure;
        boolean usedCallerProvidedCredentials = this.secure;
        do {
            boolean serverAppearsSecure;
            shouldTryCommandAgain = false;
            try {
                HttpConnectorAddress url = new HttpConnectorAddress(this.host, this.port, shouldUseSecure);
                this.logger.finer("URI: " + uriString);
                this.logger.finer("URL: " + url.toString());
                this.logger.finer("URL: " + url.toURL(uriString.toString()).toString());
                this.logger.finer("Using auth info: User: " + this.user + ", Password: " + (RemoteAdminCommand.ok(this.password) ? "<non-null>" : "<null>"));
                if (this.user != null || this.password != null) {
                    url.setAuthenticationInfo(new AuthenticationInfo(this.user, this.password));
                }
                urlConnection = (HttpURLConnection)url.openConnection(uriString.toString());
                urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
                if (shouldSendCredentials) {
                    urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
                }
                urlConnection.setRequestMethod(httpMethod);
                urlConnection.setReadTimeout(this.readTimeout);
                if (this.connectTimeout >= 0) {
                    urlConnection.setConnectTimeout(this.connectTimeout);
                }
                this.addAdminIndicatorHeaderIfReqd(urlConnection);
                cmd.doCommand(urlConnection);
                this.logger.finer("doHttpCommand succeeds");
            }
            catch (AuthenticationException authEx) {
                this.logger.log(Level.FINER, "DAS has challenged for credentials");
                if (!usedCallerProvidedCredentials) {
                    this.logger.log(Level.FINER, "Have not tried caller-supplied credentials yet; will do that next");
                    usedCallerProvidedCredentials = true;
                    shouldSendCredentials = true;
                    shouldTryCommandAgain = true;
                    continue;
                }
                this.logger.log(Level.FINER, "Already used caller-supplied credentials");
                if (askedUserForCredentials) {
                    this.logger.log(Level.FINER, "Already tried with updated credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Have not yet tried to update credentials, so will try to update them");
                if (!this.updateAuthentication()) {
                    this.logger.log(Level.FINER, "Could not update credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Was able to update the credentials so will retry with the updated ones");
                askedUserForCredentials = true;
                shouldSendCredentials = true;
                shouldTryCommandAgain = true;
            }
            catch (ConnectException ce) {
                this.logger.finer("doHttpCommand: connect exception " + ce);
                String msg = strings.get("ConnectException", this.host, this.port + "");
                throw new CommandException(msg, (Throwable)ce);
            }
            catch (UnknownHostException he) {
                this.logger.finer("doHttpCommand: host exception " + he);
                String msg = strings.get("UnknownHostException", this.host);
                throw new CommandException(msg, (Throwable)he);
            }
            catch (SocketException se) {
                this.logger.finer("doHttpCommand: socket exception " + se);
                try {
                    serverAppearsSecure = NetUtils.isSecurePort(this.host, this.port);
                    if (!serverAppearsSecure || this.secure || !this.retryUsingSecureConnection(this.host, this.port)) {
                        throw new CommandException((Throwable)se);
                    }
                    shouldUseSecure = true;
                    shouldSendCredentials = true;
                    usedCallerProvidedCredentials = true;
                    shouldTryCommandAgain = true;
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SSLException se) {
                this.logger.finer("doHttpCommand: SSL exception " + se);
                try {
                    serverAppearsSecure = NetUtils.isSecurePort(this.host, this.port);
                    if (!serverAppearsSecure && this.secure) {
                        this.logger.severe(strings.get("ServerIsNotSecure", this.host, this.port + ""));
                    }
                    throw new CommandException((Throwable)se);
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SocketTimeoutException e) {
                this.logger.finer("doHttpCommand: read timeout " + e);
                throw new CommandException(strings.get("ReadTimeout", Float.valueOf((float)this.readTimeout / 1000.0f)), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.finer("doHttpCommand: IO exception " + e);
                throw new CommandException(strings.get("IOError", e.getMessage()), (Throwable)e);
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.finer("doHttpCommand: exception " + e);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(buf));
                this.logger.finer(buf.toString());
                throw new CommandException((Throwable)e);
            }
        } while (shouldTryCommandAgain);
    }

    private void addAdminIndicatorHeaderIfReqd(URLConnection urlConnection) {
        String indicatorValue = SecureAdminClientManager.getConfiguredAdminIndicatorValue();
        if (indicatorValue != null) {
            urlConnection.setRequestProperty(SecureAdminClientManager.getConfigureAdminIndicatorHeaderName(), indicatorValue);
        }
    }

    private void checkConnect(HttpURLConnection urlConnection) throws IOException, CommandException {
        int code = urlConnection.getResponseCode();
        if (code == -1) {
            URL url = urlConnection.getURL();
            throw new CommandException(strings.get("NotHttpResponse", url.getHost(), url.getPort()));
        }
        if (code == 401) {
            throw new AuthenticationException(this.reportAuthenticationException());
        }
        if (code != 200) {
            throw new CommandException(strings.get("BadResponse", "" + code, urlConnection.getResponseMessage()));
        }
    }

    public String getUsage() {
        return this.usage;
    }

    private StringBuilder addStringOption(StringBuilder uriString, String name, String option) {
        try {
            String encodedOption = URLEncoder.encode(option, "UTF-8");
            uriString.append(name).append('=').append(encodedOption).append(QUERY_STRING_SEPARATOR);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.severe("Error encoding value for: " + name + ", Value:" + option + ", parameter value will be ignored");
        }
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, String filename) throws IOException {
        boolean uploadThisFile;
        File f = SmartFile.sanitize(new File(filename));
        this.logger.finer("FILE PARAM: " + optionName + " = " + f);
        boolean bl = uploadThisFile = this.doUpload && !f.isDirectory();
        if (uploadThisFile) {
            this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, URI.create(optionName + "/" + f.getName() + (f.isDirectory() ? "/" : "")), optionName, null, f, true);
        }
        if (f != null) {
            String pathToPass = uploadThisFile ? f.getName() : f.getPath();
            this.addStringOption(uriString, optionName, pathToPass);
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void handleResponse(ParameterMap params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream(in, userOut);
        }
    }

    private void handleResponse(ParameterMap params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code, this.logger);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            this.output = rse.getMessage();
            this.attrs = rrm.getMainAtts();
            return;
        }
        catch (RemoteException rfe) {
            if (rfe.getRemoteCause().indexOf("CommandNotFoundException") > 0) {
                throw new InvalidCommandException(rfe.getMessage());
            }
            throw new CommandException("remote failure: " + rfe.getMessage(), (Throwable)rfe);
        }
    }

    private void fetchCommandModel() throws CommandException {
        StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
        this.addStringOption(uriString, "Xhelp", "true");
        uriString.setLength(uriString.length() - 1);
        this.doHttpCommand(uriString.toString(), "GET", new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                urlConnection.setRequestProperty("User-Agent", "metadata");
                urlConnection.connect();
                RemoteAdminCommand.this.checkConnect(urlConnection);
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                RemoteAdminCommand.this.logger.finer("Response Content-Type: " + responseContentType);
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance(responseContentType, in);
                if (inboundPayload == null) {
                    throw new IOException(strings.get("NoPayloadSupport", responseContentType));
                }
                boolean isReportProcessed = false;
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        RemoteAdminCommand.this.metadataErrors = new StringBuilder();
                        RemoteAdminCommand.this.commandModel = RemoteAdminCommand.this.parseMetadata(((Payload.Part)partIt.next()).getInputStream(), RemoteAdminCommand.this.metadataErrors);
                        RemoteAdminCommand.this.logger.finer("fetchCommandModel: got command opts: " + RemoteAdminCommand.this.commandModel);
                        isReportProcessed = true;
                        continue;
                    }
                    partIt.next();
                }
            }
        });
        if (this.commandModel == null) {
            if (this.metadataErrors != null) {
                throw new InvalidCommandException(this.metadataErrors.toString());
            }
            throw new InvalidCommandException(strings.get("unknownError"));
        }
    }

    private CommandModel parseMetadata(InputStream in, StringBuilder errors) {
        if (this.logger.isLoggable(Level.FINER)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                FileUtils.copyStream(in, baos);
            }
            catch (IOException ex) {
                // empty catch block
            }
            in = new ByteArrayInputStream(baos.toByteArray());
            String response = baos.toString();
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
            this.logger.finer(response);
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
        }
        CommandModelData cm = new CommandModelData(this.name);
        boolean sawFile = false;
        try {
            NamedNodeMap attrs;
            Node n;
            int i;
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = d.parse(in);
            NodeList cmd = doc.getElementsByTagName("command");
            Node cmdnode = cmd.item(0);
            if (cmdnode == null) {
                Node report = doc.getElementsByTagName("action-report").item(0);
                String cause = RemoteAdminCommand.getAttr(report.getAttributes(), "failure-cause");
                if (RemoteAdminCommand.ok(cause)) {
                    errors.append(cause);
                } else {
                    Node mp = report.getFirstChild();
                    if (mp != null) {
                        cause = RemoteAdminCommand.getAttr(mp.getAttributes(), "message");
                    }
                    if (RemoteAdminCommand.ok(cause)) {
                        errors.append(cause);
                    }
                }
                return null;
            }
            NamedNodeMap cmdattrs = cmdnode.getAttributes();
            this.usage = RemoteAdminCommand.getAttr(cmdattrs, "usage");
            String dashOk = RemoteAdminCommand.getAttr(cmdattrs, "unknown-options-are-operands");
            if (dashOk != null) {
                cm.dashOk = Boolean.parseBoolean(dashOk);
            }
            NodeList opts = doc.getElementsByTagName("option");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                String sn = RemoteAdminCommand.getAttr(attrs, "short");
                String def = RemoteAdminCommand.getAttr(attrs, "default");
                String obs = RemoteAdminCommand.getAttr(attrs, "obsolete");
                String alias = RemoteAdminCommand.getAttr(attrs, "alias");
                CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(RemoteAdminCommand.getAttr(attrs, "name"), this.typeOf(RemoteAdminCommand.getAttr(attrs, "type")), Boolean.parseBoolean(RemoteAdminCommand.getAttr(attrs, "optional")), def, RemoteAdminCommand.ok(sn) ? sn : null, RemoteAdminCommand.ok(obs) ? Boolean.parseBoolean(obs) : false, alias);
                if (RemoteAdminCommand.getAttr(attrs, "type").equals("PASSWORD")) {
                    opt.param._password = true;
                    opt.description = RemoteAdminCommand.getAttr(attrs, "description");
                }
                cm.add(opt);
                if (opt.getType() != File.class) continue;
                sawFile = true;
            }
            opts = doc.getElementsByTagName("operand");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                Class<Object> type = this.typeOf(RemoteAdminCommand.getAttr(attrs, "type"));
                if (type == File.class) {
                    sawFile = true;
                }
                int min = Integer.parseInt(RemoteAdminCommand.getAttr(attrs, "min"));
                String max = RemoteAdminCommand.getAttr(attrs, "max");
                boolean multiple = false;
                if (max.equals("unlimited")) {
                    multiple = true;
                    type = List.class;
                }
                CommandModelData.ParamModelData pm = new CommandModelData.ParamModelData(RemoteAdminCommand.getAttr(attrs, "name"), type, min == 0, null);
                pm.param._primary = true;
                pm.param._multiple = multiple;
                cm.add(pm);
            }
            if (sawFile) {
                cm.add(new CommandModelData.ParamModelData("upload", Boolean.class, true, null));
                this.addedUploadOption = true;
            }
        }
        catch (ParserConfigurationException pex) {
            return null;
        }
        catch (SAXException sex) {
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
        return cm;
    }

    private Class<?> typeOf(String type) {
        if (type.equals("STRING")) {
            return String.class;
        }
        if (type.equals("BOOLEAN")) {
            return Boolean.class;
        }
        if (type.equals("FILE")) {
            return File.class;
        }
        if (type.equals("PASSWORD")) {
            return String.class;
        }
        if (type.equals("PROPERTIES")) {
            return Properties.class;
        }
        return String.class;
    }

    private static String getAttr(NamedNodeMap attrs, String name) {
        Node n = attrs.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void initializeDoUpload() throws CommandException {
        boolean sawFile = false;
        boolean sawDirectory = false;
        for (Map.Entry param : this.options.entrySet()) {
            CommandModel.ParamModel opt;
            String paramName = (String)param.getKey();
            if (paramName.equals("DEFAULT") || (opt = this.commandModel.getModelFor(paramName)) == null || opt.getType() != File.class) continue;
            sawFile = true;
        }
        CommandModel.ParamModel operandParam = this.getOperandModel();
        if (operandParam != null && operandParam.getType() == File.class) {
            boolean bl = sawFile = !this.operands.isEmpty();
        }
        if (sawFile) {
            String upString = this.getOption("upload");
            if (RemoteAdminCommand.ok(upString)) {
                this.doUpload = Boolean.parseBoolean(upString);
            } else {
                boolean bl = this.doUpload = !RemoteAdminCommand.isLocal(this.host);
            }
            if (sawDirectory && this.doUpload) {
                this.logger.finer("--upload=" + upString + ", doUpload=" + this.doUpload);
                throw new CommandException(strings.get("CantUploadDirectory"));
            }
        }
        if (this.addedUploadOption) {
            this.logger.finer("removing --upload option");
            ParameterMap noptions = new ParameterMap();
            for (Map.Entry e : this.options.entrySet()) {
                if (((String)e.getKey()).equals("upload")) continue;
                noptions.set(e.getKey(), (Collection)e.getValue());
            }
            this.options = noptions;
        }
        this.logger.finer("doUpload set to " + this.doUpload);
    }

    private static boolean isLocal(String hostname) {
        if (hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        try {
            InetAddress ia = InetAddress.getByName(hostname);
            return NetUtils.isLocal(ia.getHostAddress());
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    private CommandModel.ParamModel getOperandModel() {
        for (CommandModel.ParamModel pm : this.commandModel.getParameters()) {
            if (!pm.getParam().primary()) continue;
            return pm;
        }
        return null;
    }

    private String getOption(String name) {
        String def;
        CommandModel.ParamModel opt;
        String val = (String)this.options.getOne((Object)name);
        if (val == null) {
            val = this.getFromEnvironment(name);
        }
        if (val == null && (opt = this.commandModel.getModelFor(name)) != null && RemoteAdminCommand.ok(def = opt.getParam().defaultValue())) {
            val = def;
        }
        return val;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        String rt = System.getProperty(READ_TIMEOUT);
        if (rt == null) {
            rt = System.getenv(READ_TIMEOUT);
        }
        defaultReadTimeout = rt != null ? Integer.parseInt(rt) : 600000;
    }

    static interface HttpCommand {
        public void doCommand(HttpURLConnection var1) throws CommandException, IOException;
    }
}

