/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@I18n(value="versioning.service")
@Service
@Scoped(value=PerLookup.class)
public class VersioningService {
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;

    private final List<String> getAllversions(String untaggedName, String target) {
        List allApplications = null;
        allApplications = target != null ? this.domain.getApplicationsInTarget(target) : this.domain.getApplications().getApplications();
        return VersioningUtils.getVersions(untaggedName, allApplications);
    }

    public Map<String, List<String>> getAllEnabledVersionsInTargets(String name) throws VersioningSyntaxException {
        HashMap<String, List<String>> enabledVersionsInTargets = new HashMap<String, List<String>>();
        List allTargets = this.domain.getAllTargets();
        for (String target : allTargets) {
            String enabledVersion = this.getEnabledVersion(name, target);
            if (enabledVersion == null) continue;
            if (enabledVersionsInTargets.containsKey(enabledVersion)) {
                ((List)enabledVersionsInTargets.get(enabledVersion)).add(target);
                continue;
            }
            ArrayList<String> listTargets = new ArrayList<String>();
            listTargets.add(target);
            enabledVersionsInTargets.put(enabledVersion, listTargets);
        }
        return enabledVersionsInTargets;
    }

    public final String getEnabledVersion(String name, String target) throws VersioningSyntaxException {
        String untaggedName = VersioningUtils.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untaggedName, target);
        if (allVersions != null) {
            for (String app : allVersions) {
                if (!this.domain.isAppEnabledInTarget(app, target)) continue;
                return app;
            }
        }
        return null;
    }

    public final List<String> getMatchedVersions(String name, String target) throws VersioningSyntaxException, VersioningException {
        String untagged = VersioningUtils.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untagged, target);
        if (allVersions.size() == 0) {
            if (!name.equals(untagged)) {
                throw new VersioningException(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.application.noversion", "Application {0} has no version registered", new Object[]{untagged}));
            }
            return Collections.EMPTY_LIST;
        }
        return VersioningUtils.matchExpression(allVersions, name);
    }

    public void handleDisable(String appName, String target, ActionReport report) throws VersioningSyntaxException {
        String enabledVersion = this.getEnabledVersion(appName, target);
        if (enabledVersion != null && !enabledVersion.equals(appName)) {
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)enabledVersion);
            parameters.add((Object)"target", (Object)target);
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport);
            inv.parameters(parameters).execute();
        }
    }

    public String getVersionFromSameDir(File dir) throws VersioningSyntaxException {
        try {
            Iterator it = this.domain.getApplications().getApplications().iterator();
            Application app = null;
            while (it.hasNext()) {
                app = (Application)it.next();
                if (!app.getLocation().equals(dir.toURI().toString()) || VersioningUtils.getUntaggedName(app.getName()).equals(app.getName())) continue;
                return app.getName();
            }
        }
        catch (VersioningSyntaxException versioningSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

