/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class CLIManFileFinder {
    private static final String[] sections = new String[]{"1", "1m", "2", "2m", "3", "3m", "4", "4m", "5", "5m", "6", "6m", "7", "7m", "8", "8m", "9", "9m", "5asc"};
    private static final Logger logger = Logger.getLogger(CLIManFileFinder.class.getPackage().getName());

    public static Reader getCommandManFile(CLICommand cmd) {
        return CLIManFileFinder.getCommandManFile(cmd, Locale.getDefault());
    }

    public static Reader getCommandManFile(CLICommand cmd, Locale currentLocale) {
        return CLIManFileFinder.getCommandManFile(cmd, currentLocale, cmd.getClass().getClassLoader());
    }

    public static Reader getCommandManFile(CLICommand cmd, Locale locale, ClassLoader classLoader) {
        return CLIManFileFinder.getCommandManFile(CLIManFileFinder.getCommandName(cmd), cmd.getClass().getName(), locale, classLoader);
    }

    public static Reader getCommandManFile(String cmdName, String cmdClass, Locale locale, ClassLoader classLoader) {
        InputStream s = null;
        Iterator it = CLIManFileFinder.getPossibleLocations(cmdName, cmdClass, locale);
        while (s == null && it.hasNext()) {
            s = classLoader.getResourceAsStream((String)it.next());
        }
        return s == null ? (InputStreamReader)null : new InputStreamReader(s);
    }

    private static Iterator getPossibleLocations(final String cmdName, final String cmdClass, final Locale locale) {
        return new Iterator(){
            final String[] locales;
            private int i;
            private int j;
            private String helpdir;
            private String commandName;
            {
                this.locales = CLIManFileFinder.getLocaleLocations(locale);
                this.i = 0;
                this.j = 0;
                this.helpdir = CLIManFileFinder.getHelpDir(cmdClass);
                this.commandName = cmdName;
            }

            public boolean hasNext() {
                return this.i < this.locales.length && this.j < sections.length;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.helpdir + this.locales[this.i] + "/" + this.commandName + "." + sections[this.j++];
                if (this.j == sections.length) {
                    ++this.i;
                    if (this.i < this.locales.length) {
                        this.j = 0;
                    }
                }
                logger.finer("Trying to get this manpage: " + result);
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String getCommandName(CLICommand cmd) {
        String commandName = cmd.getName();
        if (commandName.length() == 0) {
            throw new IllegalArgumentException("Command name cannot be empty");
        }
        if (commandName.equals("help")) {
            commandName = "asadmin";
        }
        return commandName;
    }

    private static String getHelpDir(String cmdClass) {
        String pkgname = cmdClass.substring(0, cmdClass.lastIndexOf(46));
        return pkgname.replace('.', '/');
    }

    private static String[] getLocaleLocations(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<String> l = new ArrayList<String>();
        l.add("");
        if (language != null && language.length() > 0) {
            l.add("/" + language);
            if (country != null && country.length() > 0) {
                l.add("/" + language + "/" + country);
                if (variant != null && variant.length() > 0) {
                    l.add("/" + language + "/" + country + "/" + variant);
                }
            }
        }
        Collections.reverse(l);
        return l.toArray(new String[l.size()]);
    }
}

