/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.HashMap;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.glassfish.api.Startup;
import org.glassfish.config.support.PropertyResolver;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class MEJBClusterService
implements Startup {
    private HashMap<String, Management> instanceMEjbMap = new HashMap();
    @Inject
    private Domain domain;
    @Inject
    private static Habitat habitat;
    public static final String MEJB_NAME_PROP = "mejb.name";
    public static final String MEJB_DEFAULT_NAME = "ejb/mgmt/MEJB";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public static MEJBClusterService getInstance() {
        return (MEJBClusterService)habitat.getComponent(MEJBClusterService.class);
    }

    public synchronized Management getMEjbForInstance(String instance) throws InstanceNotFoundException {
        if (this.instanceMEjbMap.containsKey(instance)) {
            return this.instanceMEjbMap.get(instance);
        }
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        try {
            Properties props = new Properties();
            props.setProperty("org.omg.CORBA.ORBInitialHost", s.getAdminHost());
            props.setProperty("org.omg.CORBA.ORBInitialPort", new PropertyResolver(this.domain, instance).getPropertyValue("IIOP_LISTENER_PORT"));
            InitialContext ic = new InitialContext(props);
            String ejbName = System.getProperty(MEJB_NAME_PROP, MEJB_DEFAULT_NAME);
            Object objref = ic.lookup(ejbName);
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow((Object)objref, ManagementHome.class);
            Management mEJB = home.create();
            this.instanceMEjbMap.put(instance, mEJB);
            return mEJB;
        }
        catch (Exception ex) {
            throw new InstanceNotFoundException(ex.getLocalizedMessage());
        }
    }
}

