/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JvmOptionBag;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.ListJvmOptions;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.UnknownOptionsAreOperands;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-jvm-options")
@Scoped(value=PerLookup.class)
@I18n(value="create.jvm.options")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@UnknownOptionsAreOperands
public final class CreateJvmOptions
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="profiler", optional=true)
    Boolean addToProfiler = false;
    @Param(name="jvm_option_name", primary=true, separator=58)
    List<String> jvmOptions;
    @Inject
    Target targetService;
    @Inject(name="default-instance-name")
    Config config;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    private static final Logger logger = Logger.getLogger(CreateJvmOptions.class.getPackage().getName());

    @Override
    public void execute(AdminCommandContext context) {
        Config targetConfig = this.targetService.getConfig(this.target);
        if (targetConfig != null) {
            this.config = targetConfig;
        }
        JavaConfig jc = this.config.getJavaConfig();
        ActionReport report = context.getActionReport();
        try {
            JavaConfig bag;
            if (this.addToProfiler.booleanValue()) {
                if (jc.getProfiler() == null) {
                    report.setMessage(lsm.getString("create.profiler.first"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                bag = jc.getProfiler();
            } else {
                bag = jc;
            }
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            ArrayList<String> validOptions = new ArrayList<String>(this.jvmOptions);
            this.validate((JvmOptionBag)bag, validOptions, report);
            this.validateSoft((JvmOptionBag)bag, validOptions, report);
            this.addX((JvmOptionBag)bag, validOptions, part);
        }
        catch (IllegalArgumentException iae) {
            report.setMessage(iae.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : lsm.getStringWithDefault("create.jvm.options.failed", "Command: create-jvm-options failed", (Object[])new String[]{e.getMessage()});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void validateSoft(JvmOptionBag bag, List<String> opts, ActionReport report) {
        for (String opt : opts) {
            this.validateSoftXmx(bag, opt, report);
            this.validateSoftXms(bag, opt, report);
        }
    }

    private void validateSoftXmx(JvmOptionBag bag, String opt, ActionReport report) {
        int xmxGiven;
        int xmsInConfig;
        String existingXms;
        if (!opt.startsWith("-Xmx")) {
            return;
        }
        try {
            Pattern regex = Pattern.compile("-Xmx((\\d)+[m|g|k|M|G|K]?)+");
            boolean matches = regex.matcher(opt).matches();
            if (!matches) {
                String msg = lsm.getString("soft.invalid.xmx", (Object)opt);
                report.getTopMessagePart().addChild().setMessage(msg);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String existingXmx = bag.getStartingWith("-Xmx");
        if (existingXmx != null) {
            String msg = lsm.getString("soft.xmx.exists", (Object)existingXmx);
            report.getTopMessagePart().addChild().setMessage(msg);
        }
        if ((existingXms = bag.getStartingWith("-Xms")) != null && (xmsInConfig = JvmOptionBag.Duck.toMeg((String)existingXms, (String)"-Xms")) > (xmxGiven = JvmOptionBag.Duck.toMeg((String)opt, (String)"-Xmx"))) {
            String msg = lsm.getString("soft.xmx.smaller.than.xms", (Object)(xmxGiven + " MB"), (Object)(xmsInConfig + " MB"));
            report.getTopMessagePart().addChild().setMessage(msg);
        }
    }

    private void validateSoftXms(JvmOptionBag bag, String opt, ActionReport report) {
        String existingXmx;
        if (!opt.startsWith("-Xms")) {
            return;
        }
        try {
            Pattern regex = Pattern.compile("-Xms((\\d)+[m|g|k|M|G|K]?)+");
            boolean matches = regex.matcher(opt).matches();
            if (!matches) {
                String msg = lsm.getString("soft.invalid.xms", (Object)opt);
                report.getTopMessagePart().addChild().setMessage(msg);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String existingXms = bag.getStartingWith("-Xms");
        if (existingXms != null) {
            String msg = lsm.getString("soft.xms.exists", (Object)existingXms);
            report.getTopMessagePart().addChild().setMessage(msg);
        }
        if ((existingXmx = bag.getStartingWith("-Xmx")) != null) {
            int xmxInConfig = JvmOptionBag.Duck.toMeg((String)existingXmx, (String)"-Xmx");
            int xmsGiven = JvmOptionBag.Duck.toMeg((String)opt, (String)"-Xms");
            if (xmsGiven > xmxInConfig) {
                String msg = lsm.getString("soft.xms.larger.than.xmx", (Object)(xmsGiven + " MB"), (Object)(xmxInConfig + " MB"));
                report.getTopMessagePart().addChild().setMessage(msg);
            }
        }
    }

    private void validate(JvmOptionBag bag, List<String> opts, ActionReport report) {
        Iterator<String> siter = opts.iterator();
        while (siter.hasNext()) {
            String msg;
            String opt = siter.next();
            if (!opt.startsWith("-")) {
                msg = lsm.getString("joe.invalid.start", (Object)opt);
                report.getTopMessagePart().addChild().setMessage(msg);
                siter.remove();
            }
            if (!bag.contains(opt)) continue;
            msg = lsm.getString("joe.exists", (Object)opt);
            report.getTopMessagePart().addChild().setMessage(msg);
            siter.remove();
        }
    }

    private void addX(JvmOptionBag bag, final List<String> newOpts, final ActionReport.MessagePart part) throws Exception {
        SingleConfigCode<JvmOptionBag> scc = new SingleConfigCode<JvmOptionBag>(){

            public Object run(JvmOptionBag bag) throws PropertyVetoException, TransactionFailure {
                newOpts.removeAll(bag.getJvmOptions());
                ArrayList jvmopts = new ArrayList(bag.getJvmOptions());
                int orig = jvmopts.size();
                boolean added = jvmopts.addAll(newOpts);
                bag.setJvmOptions(jvmopts);
                int now = jvmopts.size();
                if (added) {
                    part.setMessage(lsm.getString("created.message", (Object)(now - orig)));
                } else {
                    part.setMessage(lsm.getString("no.option.created"));
                }
                return true;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)bag);
    }
}

