/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
public class DisableCommand
extends UndeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Param(optional=true, defaultValue="false")
    public Boolean isundeploy = false;
    @Inject
    ServerEnvironment env;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    Applications applications;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;
    @Inject
    Habitat habitat;

    public DisableCommand() {
        this.origin = OpsParams.Origin.unload;
    }

    public void execute(AdminCommandContext context) {
        Set enabledVersionsToDisable;
        String appName2;
        Logger logger;
        ActionReport report;
        block26: {
            report = context.getActionReport();
            logger = context.getLogger();
            appName2 = this.name();
            if (this.isundeploy.booleanValue()) {
                this.origin = OpsParams.Origin.undeploy;
            }
            boolean isVersionExpressionWithWilcard = VersioningUtils.isVersionExpressionWithWildCard((String)appName2);
            enabledVersionsToDisable = Collections.EMPTY_SET;
            if (this.env.isDas() && DeploymentUtils.isDomainTarget((String)this.target)) {
                Map enabledVersionsInTargets = Collections.EMPTY_MAP;
                if (isVersionExpressionWithWilcard) {
                    enabledVersionsInTargets = this.versioningService.getEnabledVersionInReferencedTargetsForExpression(appName2);
                } else {
                    enabledVersionsInTargets = new HashMap();
                    enabledVersionsInTargets.put(appName2, new HashSet(this.domain.getAllReferencedTargetsForApplication(appName2)));
                }
                enabledVersionsToDisable = enabledVersionsInTargets.keySet();
                for (Map.Entry entry : enabledVersionsInTargets.entrySet()) {
                    appName2 = (String)entry.getKey();
                    ArrayList targets = new ArrayList((Set)entry.getValue());
                    try {
                        ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{this});
                        ParameterMap paramMap = extractor.extract((Collection)Collections.EMPTY_LIST);
                        paramMap.set((Object)"DEFAULT", (Object)appName2);
                        ClusterOperationUtil.replicateCommand((String)"disable", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
                    }
                    catch (Exception e) {
                        report.failure(logger, e.getMessage());
                        return;
                    }
                }
            } else if (isVersionExpressionWithWilcard) {
                try {
                    List matchedVersions = this.versioningService.getMatchedVersions(appName2, this.target);
                    if (matchedVersions == Collections.EMPTY_LIST) {
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return;
                    }
                    String enabledVersion = this.versioningService.getEnabledVersion(appName2, this.target);
                    if (!matchedVersions.contains(enabledVersion)) {
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return;
                    }
                    appName2 = enabledVersion;
                }
                catch (VersioningException e) {
                    report.failure(logger, e.getMessage());
                    return;
                }
            }
            if (this.env.isDas() || !this.isundeploy.booleanValue()) {
                ApplicationRef ref;
                if (!this.deployment.isRegistered(appName2)) {
                    report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{appName2}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (!DeploymentUtils.isDomainTarget((String)this.target) && (ref = this.domain.getApplicationRefInTarget(appName2, this.target)) == null) {
                    report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{appName2, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ApplicationInfo appInfo = this.deployment.get(appName2);
            if (!this.domain.isCurrentInstanceMatchingTarget(this.target, appName2, this.server.getName(), null)) {
                if (!this.isundeploy.booleanValue()) {
                    try {
                        this.deployment.updateAppEnabledAttributeInDomainXML(appName2, this.target, false);
                    }
                    catch (TransactionFailure e) {
                        logger.warning("failed to set enable attribute for " + appName2);
                    }
                }
                this.events.send(new EventListener.Event(Deployment.APPLICATION_DISABLED, (Object)appInfo));
                return;
            }
            try {
                Application app = this.applications.getApplication(appName2);
                this.name = appName2;
                this.deployment.disable((UndeployCommandParameters)this, app, appInfo, report, logger);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during disabling: ", e);
                if (!this.env.isDas() && this.isundeploy.booleanValue()) break block26;
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(e.getMessage());
            }
        }
        if (enabledVersionsToDisable == Collections.EMPTY_SET) {
            enabledVersionsToDisable = new HashSet();
            enabledVersionsToDisable.add(appName2);
        }
        for (String appName2 : enabledVersionsToDisable) {
            if (this.isundeploy.booleanValue() || report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) continue;
            try {
                this.deployment.updateAppEnabledAttributeInDomainXML(appName2, this.target, false);
            }
            catch (TransactionFailure e) {
                logger.warning("failed to set enable attribute for " + appName2);
            }
        }
    }
}

