/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable")
@I18n(value="enable.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
public class EnableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;

    public void execute(AdminCommandContext context) {
        ApplicationRef applicationRef;
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (!this.deployment.isRegistered(this.name())) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!DeploymentUtils.isDomainTarget((String)this.target) && (applicationRef = this.domain.getApplicationRefInTarget(this.name(), this.target)) == null) {
            report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name(), this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.domain.isAppEnabledInTarget(this.name(), this.target)) {
            logger.fine("The application is already enabled");
            return;
        }
        if (this.env.isDas()) {
            try {
                this.versioningService.handleDisable(this.name(), this.target, report);
            }
            catch (VersioningSyntaxException e) {
                report.failure(logger, e.getMessage());
                return;
            }
            if (DeploymentUtils.isDomainTarget((String)this.target)) {
                List targets = this.domain.getAllReferencedTargetsForApplication(this.name());
                try {
                    ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{this});
                    ParameterMap paramMap = extractor.extract((Collection)Collections.EMPTY_LIST);
                    paramMap.set((Object)"DEFAULT", (Object)this.name());
                    ClusterOperationUtil.replicateCommand((String)"enable", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (Collection)targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
                }
                catch (Exception e) {
                    report.failure(logger, e.getMessage());
                    return;
                }
            }
        }
        if (!this.domain.isCurrentInstanceMatchingTarget(this.target, this.name(), this.server.getName(), null)) {
            try {
                this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, true);
            }
            catch (TransactionFailure e) {
                logger.warning("failed to set enable attribute for " + this.name());
            }
            return;
        }
        try {
            Application app = this.applications.getApplication(this.name());
            ApplicationRef appRef = this.domain.getApplicationRefInServer(this.server.getName(), this.name());
            this.deployment.enable(this.target, app, appRef, report, logger);
            if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, true);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to set enable attribute for " + this.name());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during enabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

