/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.v3.admin.MbeanService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DynamicInterceptor
implements MBeanServer {
    private volatile MBeanServer mDelegateMBeanServer = null;
    private static HashMap<String, MBeanServerConnection> instanceConnections;

    public DynamicInterceptor() {
        instanceConnections = new HashMap();
    }

    private String getInstance(ObjectName o) throws InstanceNotFoundException {
        String j2eeTypeProp = o.getKeyProperty("j2eeType");
        if (!MbeanService.getInstance().isDas()) {
            return "server";
        }
        if ("J2EEDomain".equals(j2eeTypeProp)) {
            return "server";
        }
        String name = j2eeTypeProp != null && j2eeTypeProp.equals("J2EEServer") ? o.getKeyProperty("name") : o.getKeyProperty("J2EEServer");
        return MbeanService.getInstance().isValidServer(name) ? name : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerConnection getInstanceConnection(String instanceName) throws InstanceNotFoundException {
        if (!instanceConnections.containsKey(instanceName)) {
            DynamicInterceptor dynamicInterceptor = this;
            synchronized (dynamicInterceptor) {
                try {
                    String urlStr = "service:jmx:rmi:///jndi/rmi://" + MbeanService.getInstance().getHost(instanceName) + ":" + MbeanService.getInstance().getJMXPort(instanceName) + "/jmxrmi";
                    JMXServiceURL url = new JMXServiceURL(urlStr);
                    JMXConnector jmxConn = JMXConnectorFactory.connect(url);
                    MBeanServerConnection conn = jmxConn.getMBeanServerConnection();
                    instanceConnections.put(instanceName, conn);
                }
                catch (Exception ex) {
                    throw new InstanceNotFoundException(ex.getLocalizedMessage());
                }
            }
        }
        return instanceConnections.get(instanceName);
    }

    public MBeanServer getDelegateMBeanServer() {
        return this.mDelegateMBeanServer;
    }

    public void setDelegateMBeanServer(MBeanServer server) {
        this.mDelegateMBeanServer = server;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().invoke(objectName, operationName, params, signature);
        }
        try {
            return this.getInstanceConnection(instance).invoke(objectName, operationName, params, signature);
        }
        catch (IOException ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().getAttribute(objectName, attributeName);
        }
        try {
            return this.getInstanceConnection(instance).getAttribute(objectName, attributeName);
        }
        catch (IOException ioex) {
            throw new MBeanException(ioex);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            this.getDelegateMBeanServer().setAttribute(objectName, attribute);
            return;
        }
        try {
            this.getInstanceConnection(instance).setAttribute(objectName, attribute);
        }
        catch (IOException ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().getAttributes(objectName, attrNames);
        }
        try {
            return this.getInstanceConnection(instance).getAttributes(objectName, attrNames);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().setAttributes(objectName, attributeList);
        }
        try {
            return this.getInstanceConnection(instance).setAttributes(objectName, attributeList);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final ObjectInstance registerMBean(Object obj, ObjectName objectName) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        return this.getDelegateMBeanServer().registerMBean(obj, objectName);
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.getDelegateMBeanServer().unregisterMBean(objectName);
    }

    public final Integer getMBeanCount() {
        return this.getDelegateMBeanServer().getMBeanCount();
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp expr) {
        try {
            String instance = this.getInstance(objectName);
            if (instance == null || instance.equals("server")) {
                return this.getDelegateMBeanServer().queryMBeans(objectName, expr);
            }
            return this.getInstanceConnection(instance).queryMBeans(objectName, expr);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().getMBeanInfo(objectName);
        }
        try {
            return this.getInstanceConnection(instance).getMBeanInfo(objectName);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final boolean isRegistered(ObjectName objectName) {
        try {
            String instance = this.getInstance(objectName);
            if (instance == null || instance.equals("server")) {
                return this.getDelegateMBeanServer().isRegistered(objectName);
            }
            return this.getInstanceConnection(instance).isRegistered(objectName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.getDelegateMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.getDelegateMBeanServer().addNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getDelegateMBeanServer().createMBean(str, objectName);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getDelegateMBeanServer().createMBean(str, objectName, objectName2);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getDelegateMBeanServer().createMBean(str, objectName, obj, str3);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getDelegateMBeanServer().createMBean(str, objectName, objectName2, obj, str4);
    }

    public final ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, values);
    }

    public final ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        return this.getDelegateMBeanServer().deserialize(objectName, values);
    }

    public final ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, objectName, values);
    }

    public final String getDefaultDomain() {
        return this.getDelegateMBeanServer().getDefaultDomain();
    }

    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().getObjectInstance(objectName);
        }
        try {
            return this.getInstanceConnection(instance).getObjectInstance(objectName);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final Object instantiate(String str) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str);
    }

    public final Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.getDelegateMBeanServer().instantiate(str, objectName);
    }

    public final Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str, obj, str2);
    }

    public final Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.getDelegateMBeanServer().instantiate(str, objectName, obj, str3);
    }

    public final boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        String instance = this.getInstance(objectName);
        if (instance == null || instance.equals("server")) {
            return this.getDelegateMBeanServer().isInstanceOf(objectName, str);
        }
        try {
            return this.getInstanceConnection(instance).isInstanceOf(objectName, str);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        try {
            String instance = this.getInstance(objectName);
            if (instance == null || instance.equals("server")) {
                return this.getDelegateMBeanServer().queryNames(objectName, queryExp);
            }
            return this.getInstanceConnection(instance).queryNames(objectName, queryExp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getDelegateMBeanServer().getClassLoader(objectName);
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.getDelegateMBeanServer().getClassLoaderFor(objectName);
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        return this.getDelegateMBeanServer().getClassLoaderRepository();
    }

    public final String[] getDomains() {
        return this.getDelegateMBeanServer().getDomains();
    }
}

