/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import javax.management.InstanceNotFoundException;
import org.glassfish.api.Startup;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class MbeanService
implements Startup {
    @Inject
    private Domain domain;
    @Inject
    private Target tgt;
    @Inject
    private static Habitat habitat;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public static MbeanService getInstance() {
        return (MbeanService)habitat.getComponent(MbeanService.class);
    }

    public String getHost(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return s.getAdminHost();
    }

    public String getJMXPort(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return new PropertyResolver(this.domain, instance).getPropertyValue("JMX_SYSTEM_CONNECTOR_PORT");
    }

    public boolean isDas() {
        return this.tgt.isThisDAS();
    }

    public boolean isValidServer(String name) {
        Server s = null;
        try {
            s = this.domain.getServerNamed(name);
        }
        catch (Throwable t) {
            return false;
        }
        return s != null;
    }
}

