/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.EmbeddedOSGiGlassFishRuntimeBuilder;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import org.glassfish.simpleglassfishapi.BootstrapOptions;
import org.glassfish.simpleglassfishapi.GlassFish;
import org.glassfish.simpleglassfishapi.GlassFishOptions;
import org.glassfish.simpleglassfishapi.GlassFishRuntime;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class GlassFishMainActivator
implements BundleActivator {
    private GlassFishRuntime gfr;
    private GlassFish gf;

    public void start(BundleContext context) throws Exception {
        Properties properties = this.prepareStartupContext(context);
        this.gfr = GlassFishRuntime.bootstrap(new BootstrapOptions(properties), this.getClass().getClassLoader());
        this.gf = this.gfr.newGlassFish(new GlassFishOptions(properties));
        this.gf.start();
    }

    private Properties prepareStartupContext(BundleContext context) {
        Properties properties = new Properties();
        String installRoot = context.getProperty("com.sun.aas.installRoot");
        if (installRoot == null) {
            installRoot = this.guessInstallRoot(context);
            if (installRoot == null) {
                throw new RuntimeException("Property named com.sun.aas.installRoot is not set.");
            }
            System.out.println("Deduced install root as : " + installRoot + " from location of bundle. " + "If this is not correct, set correct value in a property called " + "com.sun.aas.installRoot");
        }
        if (!new File(installRoot).exists()) {
            throw new RuntimeException("No such directory: [" + installRoot + "]");
        }
        properties.setProperty("com.sun.aas.installRoot", installRoot);
        String instanceRoot = properties.getProperty("com.sun.aas.instanceRoot");
        if (instanceRoot == null) {
            instanceRoot = new File(installRoot, "domains/domain1/").getAbsolutePath();
        }
        properties.setProperty("com.sun.aas.instanceRoot", instanceRoot);
        properties.setProperty("GlassFish.BUILDER_NAME", EmbeddedOSGiGlassFishRuntimeBuilder.class.getName());
        return properties;
    }

    private String guessInstallRoot(BundleContext context) {
        String location = context.getBundle().getLocation();
        try {
            URI uri = URI.create(location);
            File f = new File(uri);
            if (f.exists() && f.isFile() && f.getParentFile().getCanonicalPath().endsWith("modules") && f.getParentFile().getParentFile().getCanonicalPath().endsWith("glassfish")) {
                return f.getParentFile().getParentFile().getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void stop(BundleContext context) throws Exception {
        this.gf.stop();
    }
}

