/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.simpleglassfishapi.GlassFish;
import org.glassfish.simpleglassfishapi.GlassFishException;
import org.glassfish.simpleglassfishapi.GlassFishOptions;
import org.glassfish.simpleglassfishapi.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;

public class NonOSGiGlassFishRuntime
extends GlassFishRuntime {
    private Main main;
    private HashMap gfMap = new HashMap();
    private static Logger logger = Util.getLogger();

    public NonOSGiGlassFishRuntime(Main main) {
        this.main = main;
    }

    public GlassFish newGlassFish(GlassFishOptions gfOptions) throws GlassFishException {
        try {
            this.setEnv(gfOptions);
            StartupContext startupContext = new StartupContext(gfOptions.getAllOptions());
            ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
            Habitat habitat = this.main.createHabitat(modulesRegistry, startupContext);
            ModuleStartup gfKernel = this.main.findStartupService(modulesRegistry, habitat, null, startupContext);
            GlassFishImpl gfImpl = new GlassFishImpl(gfKernel, habitat, gfOptions.getAllOptions());
            this.gfMap.put(gfOptions.getInstanceRoot(), gfImpl);
            return gfImpl;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    protected void disposeGlassFishInstances() {
        for (Object gf : this.gfMap.values()) {
            ((GlassFish)gf).dispose();
        }
    }

    private void setEnv(GlassFishOptions gfOptions) throws Exception {
        String instanceRootValue = gfOptions.getInstanceRoot();
        if (instanceRootValue == null) {
            instanceRootValue = this.createDefaultInstanceRoot();
            gfOptions.setInstanceRoot(instanceRootValue);
            gfOptions.setInstanceRootUri(new File(instanceRootValue).toURI().toString());
        }
        File instanceRoot = new File(instanceRootValue);
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        this.provisionInstanceRoot(instanceRoot, gfOptions.getAllOptions());
        this.copyConfigFile(gfOptions.getConfigFileUri(), instanceRootValue);
    }

    private String createDefaultInstanceRoot() throws Exception {
        String tmpDir = System.getProperty("glassfish.embedded.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("user.dir");
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        instanceRoot.delete();
        instanceRoot.mkdir();
        return instanceRoot.getAbsolutePath();
    }

    private void provisionInstanceRoot(File instanceRoot, Properties props) {
        new File(instanceRoot, "config").mkdirs();
        new File(instanceRoot, "docroot").mkdirs();
        try {
            File discoveredInstallRoot = ASMainHelper.findInstallRoot();
            File discoveredInstanceRoot = ASMainHelper.findInstanceRoot(discoveredInstallRoot, props);
            if (!discoveredInstanceRoot.equals(instanceRoot)) {
                this.copy(discoveredInstanceRoot, instanceRoot, "config", "docroot");
            }
        }
        catch (Exception ex) {
            logger.warning(ex.getMessage());
        }
    }

    private void copy(final File srcDir, final File dstDir, final String ... subDirs) {
        srcDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                if (path.isDirectory()) {
                    path.listFiles(this);
                } else {
                    for (String subDir : subDirs) {
                        File dstFile;
                        String srcPath = new File(srcDir, subDir).getPath();
                        if (!path.getPath().startsWith(srcPath) || (dstFile = new File(dstDir, path.getPath().substring(srcDir.getPath().length()))).exists()) continue;
                        dstFile.getParentFile().mkdirs();
                        try {
                            Util.copyFile(path, dstFile);
                        }
                        catch (Exception ex) {
                            logger.warning(ex.getMessage());
                        }
                    }
                }
                return false;
            }
        });
    }

    private void copyConfigFile(String configFileURI, String instanceRoot) throws Exception {
        if (configFileURI != null && instanceRoot != null) {
            URI configFile = URI.create(configFileURI);
            InputStream stream = configFile.toURL().openConnection().getInputStream();
            File domainXml = new File(instanceRoot, "config/domain.xml");
            logger.finer("domainXML uri = " + configFileURI + ", size = " + stream.available());
            if (!domainXml.toURI().equals(configFile)) {
                Util.copy(stream, new FileOutputStream(domainXml), stream.available());
                logger.finer("Created " + domainXml);
            } else {
                logger.finer("Skipped creation of " + domainXml);
            }
        }
    }
}

