/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketApplication
implements WebSocketListener {
    private final ConcurrentHashMap<WebSocket, Boolean> sockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<WebSocketListener, Boolean> listeners = new ConcurrentHashMap();

    protected Set<WebSocket> getWebSockets() {
        return this.sockets.keySet();
    }

    protected boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    public boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }

    public WebSocket createSocket(NetworkHandler handler, WebSocketListener ... listeners) throws IOException {
        return new BaseServerWebSocket(handler, listeners);
    }

    @Override
    public void onClose(WebSocket socket) throws IOException {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    @Override
    public void onMessage(WebSocket socket, DataFrame data) throws IOException {
    }
}

