/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramOptions {
    private static final Set<CommandModel.ParamModel> programOptions;
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String TERSE = "terse";
    public static final String ECHO = "echo";
    public static final String INTERACTIVE = "interactive";
    public static final String SECURE = "secure";
    public static final String HELP = "help";
    private static final Logger logger;
    private static final LocalStringsImpl strings;
    private ParameterMap options;
    private Environment env;
    private boolean optionsSet;
    private String password;
    private PasswordLocation location;
    private String classPath;
    private String className;

    private static void addMetaOption(Set<CommandModel.ParamModel> opts, String name, char sname, Class type, boolean req, String def) {
        CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(name, type, !req, def, Character.toString(sname));
        opts.add((CommandModel.ParamModel)opt);
    }

    public ProgramOptions(Environment env) throws CommandException {
        this(new ParameterMap(), env);
        this.optionsSet = false;
    }

    public ProgramOptions(ParameterMap options, Environment env) throws CommandException {
        this.env = env;
        this.updateOptions(options);
    }

    public ProgramOptions(ProgramOptions other) {
        this.options = new ParameterMap(other.options);
        this.env = other.env;
        this.password = other.password;
        this.classPath = other.classPath;
        this.className = other.className;
    }

    public void updateOptions(ParameterMap newOptions) throws CommandException {
        if (this.options == null) {
            this.options = newOptions;
        } else {
            for (Map.Entry e : newOptions.entrySet()) {
                this.options.set(e.getKey(), (Collection)e.getValue());
            }
        }
        this.optionsSet = true;
        String sport = (String)this.options.getOne((Object)PORT);
        if (ProgramOptions.ok(sport)) {
            String badPortMsg = strings.get("InvalidPortNumber", new Object[]{sport});
            try {
                int port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    throw new CommandException(badPortMsg);
                }
            }
            catch (NumberFormatException e) {
                throw new CommandException(badPortMsg);
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static Collection<CommandModel.ParamModel> getValidOptions() {
        return programOptions;
    }

    public void toEnvironment(Environment env) {
        this.putEnv(env, ECHO);
        this.putEnv(env, TERSE);
        this.putEnv(env, INTERACTIVE);
        this.putEnv(env, HOST);
        this.putEnv(env, PORT);
        this.putEnv(env, SECURE);
        this.putEnv(env, USER);
        this.putEnv(env, PASSWORDFILE);
    }

    private void putEnv(Environment env, String name) {
        String value = (String)this.options.getOne((Object)name);
        if (value != null) {
            env.putOption(name, value);
        }
    }

    public String getHost() {
        String host = (String)this.options.getOne((Object)HOST);
        if (!ProgramOptions.ok(host)) {
            host = this.env.getStringOption(HOST);
        }
        if (!ProgramOptions.ok(host)) {
            host = "localhost";
        }
        return host;
    }

    public void setHost(String host) {
        this.options.set((Object)HOST, (Object)host);
    }

    public int getPort() {
        int port;
        String sport = (String)this.options.getOne((Object)PORT);
        if (!ProgramOptions.ok(sport)) {
            sport = this.env.getStringOption(PORT);
        }
        if (ProgramOptions.ok(sport)) {
            try {
                port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    port = -1;
                }
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        } else {
            port = 4848;
        }
        return port;
    }

    public void setPort(int port) {
        this.options.set((Object)PORT, (Object)Integer.toString(port));
    }

    public void setHostAndPort(HostAndPort address) {
        this.setHost(address.getHost());
        this.setPort(address.getPort());
        this.setSecure(address.isSecure());
    }

    public String getUser() {
        String user = (String)this.options.getOne((Object)USER);
        if (!ProgramOptions.ok(user)) {
            user = this.env.getStringOption(USER);
        }
        if (!ProgramOptions.ok(user)) {
            user = null;
        }
        return user;
    }

    public void setUser(String user) {
        logger.finer("Setting user to: " + user);
        this.options.set((Object)USER, (Object)user);
    }

    public String getPassword() {
        return this.password;
    }

    public PasswordLocation getPasswordLocation() {
        return this.location;
    }

    public void setPassword(String password, PasswordLocation location) {
        logger.finer("Setting password to: " + (ProgramOptions.ok(password) ? "<non-null>" : "<null>"));
        this.password = password;
        this.location = location;
    }

    public String getPasswordFile() {
        String passwordFile = (String)this.options.getOne((Object)PASSWORDFILE);
        if (!ProgramOptions.ok(passwordFile)) {
            passwordFile = this.env.getStringOption(PASSWORDFILE);
        }
        if (!ProgramOptions.ok(passwordFile)) {
            passwordFile = null;
        }
        return passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.options.set((Object)PASSWORDFILE, (Object)passwordFile);
    }

    public boolean isSecure() {
        String value;
        boolean secure = this.options.containsKey((Object)SECURE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)SECURE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(SECURE);
        return secure;
    }

    public void setSecure(boolean secure) {
        this.options.set((Object)SECURE, (Object)Boolean.toString(secure));
    }

    public boolean isTerse() {
        String value;
        boolean terse = this.options.containsKey((Object)TERSE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)TERSE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(TERSE);
        return terse;
    }

    public void setTerse(boolean terse) {
        this.options.set((Object)TERSE, (Object)Boolean.toString(terse));
    }

    public boolean isEcho() {
        String value;
        boolean echo = this.options.containsKey((Object)ECHO) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)ECHO)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(ECHO);
        return echo;
    }

    public void setEcho(boolean echo) {
        this.options.set((Object)ECHO, (Object)Boolean.toString(echo));
    }

    public boolean isInteractive() {
        String value;
        boolean interactive = this.options.containsKey((Object)INTERACTIVE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)INTERACTIVE)) ? Boolean.parseBoolean(value) : true) : (this.env.hasOption(INTERACTIVE) ? this.env.getBooleanOption(INTERACTIVE) : System.console() != null);
        return interactive;
    }

    public void setInteractive(boolean interactive) {
        this.options.set((Object)INTERACTIVE, (Object)Boolean.toString(interactive));
    }

    public boolean isHelp() {
        String value;
        boolean help = false;
        help = this.options.containsKey((Object)HELP) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)HELP)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(HELP);
        return help;
    }

    public void setHelp(boolean help) {
        this.options.set((Object)HELP, (Object)Boolean.toString(help));
    }

    public boolean isOptionsSet() {
        return this.optionsSet;
    }

    public void setOptionsSet(boolean optionsSet) {
        this.optionsSet = optionsSet;
    }

    public String[] getProgramArguments() {
        ArrayList<String> args = new ArrayList<String>(15);
        if (ProgramOptions.ok(this.getHost())) {
            args.add("--host");
            args.add(this.getHost());
        }
        if (this.getPort() > 0) {
            args.add("--port");
            args.add(String.valueOf(this.getPort()));
        }
        if (ProgramOptions.ok(this.getUser())) {
            args.add("--user");
            args.add(this.getUser());
        }
        if (ProgramOptions.ok(this.getPasswordFile())) {
            args.add("--passwordfile");
            args.add(this.getPasswordFile());
        }
        args.add("--secure=" + String.valueOf(this.isSecure()));
        args.add("--terse=" + String.valueOf(this.isTerse()));
        args.add("--echo=" + String.valueOf(this.isEcho()));
        args.add("--interactive=" + String.valueOf(this.isInteractive()));
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (ProgramOptions.ok(this.getHost())) {
            sb.append("--host ").append(this.getHost()).append(' ');
        }
        if (this.getPort() > 0) {
            sb.append("--port ").append(this.getPort()).append(' ');
        }
        if (ProgramOptions.ok(this.getUser())) {
            sb.append("--user ").append(this.getUser()).append(' ');
        }
        if (ProgramOptions.ok(this.getPasswordFile())) {
            sb.append("--passwordfile ").append(this.getPasswordFile()).append(' ');
        }
        if (this.isSecure()) {
            sb.append("--secure ");
        }
        sb.append("--interactive=").append(Boolean.toString(this.isInteractive())).append(' ');
        sb.append("--echo=").append(Boolean.toString(this.isEcho())).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.isTerse())).append(' ');
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static {
        logger = Logger.getLogger(ProgramOptions.class.getPackage().getName());
        strings = new LocalStringsImpl(ProgramOptions.class);
        HashSet<CommandModel.ParamModel> opts = new HashSet<CommandModel.ParamModel>();
        ProgramOptions.addMetaOption(opts, HOST, 'H', String.class, false, "localhost");
        ProgramOptions.addMetaOption(opts, PORT, 'p', String.class, false, "4848");
        ProgramOptions.addMetaOption(opts, USER, 'u', String.class, false, null);
        ProgramOptions.addMetaOption(opts, PASSWORDFILE, 'W', File.class, false, null);
        ProgramOptions.addMetaOption(opts, SECURE, 's', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, TERSE, 't', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, ECHO, 'e', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, INTERACTIVE, 'I', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, HELP, '?', Boolean.class, false, "false");
        programOptions = Collections.unmodifiableSet(opts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PasswordLocation {
        DEFAULT,
        USER,
        PASSWORD_FILE,
        LOGIN_FILE,
        LOCAL_PASSWORD;

    }
}

