/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="list-log-levels")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@Scoped(value=PerLookup.class)
@I18n(value="list.log.levels")
public class ListLoggerLevels
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;
    @Param(optional=true)
    String target = "server";
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLoggerLevels.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        try {
            Cluster clusterForInstance;
            HashMap props = null;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null && targetServer.isDas()) {
                isDas = true;
            } else {
                Cluster cluster = this.domain.getClusterNamed(this.target);
                if (cluster != null) {
                    isCluster = true;
                } else {
                    isInstance = true;
                }
            }
            if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                this.target = clusterForInstance.getName();
            }
            if (isCluster || isInstance) {
                props = (HashMap)this.loggingConfig.getLoggingProperties(this.target);
            } else if (isDas) {
                props = (HashMap)this.loggingConfig.getLoggingProperties();
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String clusterName = "";
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{this.target});
                if (targetServer != null && targetServer.isInstance()) {
                    clusterName = targetServer.getCluster().getName();
                    msg = localStrings.getLocalString("invalid.target.sys.props", "Instance {0} is part of the Cluster so valid target value is '" + clusterName + "'.", new Object[]{this.target});
                }
                report.setMessage(msg);
                return;
            }
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap logLevelMap = new HashMap();
            ArrayList<String> loggerList = new ArrayList<String>();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (!name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                String n = name.substring(0, name.lastIndexOf(".level"));
                part.setMessage(n + ": " + (String)props.get(name));
                logLevelMap.put(n, props.get(name));
                loggerList.add(n);
            }
            Properties restData = new Properties();
            restData.put("logLevels", logLevelMap);
            restData.put("loggers", loggerList);
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage("Unable to get the logger names");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

