/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.MbeanService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DynamicInterceptor
implements MBeanServer {
    private volatile MBeanServer mDelegateMBeanServer = null;
    private static HashMap<String, MBeanServerConnection> instanceConnections;
    private static final LocalStringManagerImpl localStrings;

    public DynamicInterceptor() {
        instanceConnections = new HashMap();
    }

    private ReplicationInfo getInstance(ObjectName o) throws InstanceNotFoundException {
        ReplicationInfo result = new ReplicationInfo();
        List<String> instances = result.getInstances();
        if (o == null) {
            instances.add("server");
            return result;
        }
        String j2eeTypeProp = o.getKeyProperty("j2eeType");
        String oName = o.toString();
        try {
            if (MbeanService.getInstance() == null) {
                instances.add("server");
            } else if (!MbeanService.getInstance().isDas()) {
                instances.add("server");
            } else if (oName.startsWith("amx:pp=/domain/configs/config[")) {
                String configName = oName.substring(oName.indexOf("[") + 1, oName.indexOf("-config"));
                instances.add("server");
                instances.addAll(MbeanService.getInstance().getInstances(configName));
            } else if (oName.startsWith("amx:pp=/domain/clusters/cluster[")) {
                String clusterName = oName.substring(oName.indexOf("[") + 1, oName.indexOf("]"));
                instances.add("server");
                instances.addAll(MbeanService.getInstance().getInstances(clusterName));
            } else if (oName.startsWith("amx:pp=/domain/servers/server[")) {
                String svrName = oName.substring(oName.indexOf("[") + 1, oName.indexOf("]"));
                instances.add(svrName);
                result.setTargetIsAnInstance(true);
            } else if ("amx:*".equals(oName) || "*.*".equals(oName)) {
                instances.add("server");
                instances.addAll(MbeanService.getInstance().getAllInstances());
            } else if ("J2EEDomain".equals(j2eeTypeProp)) {
                instances.add("server");
            } else {
                String name = j2eeTypeProp != null && j2eeTypeProp.equals("J2EEServer") ? o.getKeyProperty("name") : o.getKeyProperty("J2EEServer");
                if (MbeanService.getInstance().isValidServer(name)) {
                    instances.add(name);
                    if (!"server".equals(name)) {
                        result.setTargetIsAnInstance(true);
                    }
                } else {
                    instances.add("server");
                }
            }
        }
        catch (Exception e) {
            throw new InstanceNotFoundException(e.getLocalizedMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerConnection getInstanceConnection(String instanceName) throws InstanceNotFoundException {
        if (!instanceConnections.containsKey(instanceName)) {
            DynamicInterceptor dynamicInterceptor = this;
            synchronized (dynamicInterceptor) {
                try {
                    String urlStr = "service:jmx:rmi:///jndi/rmi://" + MbeanService.getInstance().getHost(instanceName) + ":" + MbeanService.getInstance().getJMXPort(instanceName) + "/jmxrmi";
                    JMXServiceURL url = new JMXServiceURL(urlStr);
                    JMXConnector jmxConn = JMXConnectorFactory.connect(url);
                    MBeanServerConnection conn = jmxConn.getMBeanServerConnection();
                    instanceConnections.put(instanceName, conn);
                }
                catch (Exception ex) {
                    throw new InstanceNotFoundException(ex.getLocalizedMessage());
                }
            }
        }
        return instanceConnections.get(instanceName);
    }

    public MBeanServer getDelegateMBeanServer() {
        return this.mDelegateMBeanServer;
    }

    public void setDelegateMBeanServer(MBeanServer server) {
        this.mDelegateMBeanServer = server;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        Object returnValue = null;
        try {
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    returnValue = this.getDelegateMBeanServer().invoke(objectName, operationName, params, signature);
                    continue;
                }
                returnValue = this.getInstanceConnection(svr).invoke(objectName, operationName, params, signature);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
        return returnValue;
    }

    public final Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        if (!result.isTargetAnInstance()) {
            return this.getDelegateMBeanServer().getAttribute(objectName, attributeName);
        }
        try {
            return this.getInstanceConnection(result.getInstances().get(0)).getAttribute(objectName, attributeName);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).setAttribute(objectName, attribute);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().setAttribute(objectName, attribute);
                    continue;
                }
                this.getInstanceConnection(svr).setAttribute(objectName, attribute);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    public final AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).getAttributes(objectName, attrNames);
            }
            return this.getDelegateMBeanServer().getAttributes(objectName, attrNames);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        AttributeList ret = null;
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).setAttributes(objectName, attributeList);
            }
            for (String svr : result.getInstances()) {
                if (result.getInstances().get(0).equals("server")) {
                    ret = this.getDelegateMBeanServer().setAttributes(objectName, attributeList);
                    continue;
                }
                ret = this.getInstanceConnection(svr).setAttributes(objectName, attributeList);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
        return ret;
    }

    public final ObjectInstance registerMBean(Object obj, ObjectName objectName) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        return this.getDelegateMBeanServer().registerMBean(obj, objectName);
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).unregisterMBean(objectName);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().unregisterMBean(objectName);
                    continue;
                }
                this.getInstanceConnection(svr).unregisterMBean(objectName);
            }
        }
        catch (IOException io) {
            throw new MBeanRegistrationException(io);
        }
    }

    public final Integer getMBeanCount() {
        return this.getDelegateMBeanServer().getMBeanCount();
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp expr) {
        if (objectName == null) {
            return Collections.EMPTY_SET;
        }
        try {
            Set<ObjectInstance> returnVal = null;
            List<String> instance = this.getInstance(objectName).getInstances();
            for (String ins : instance) {
                Set<ObjectInstance> tmp = ins.equals("server") ? this.getDelegateMBeanServer().queryMBeans(objectName, expr) : this.getInstanceConnection(ins).queryMBeans(objectName, expr);
                if (returnVal == null) {
                    returnVal = tmp;
                    continue;
                }
                returnVal.addAll(tmp);
            }
            return returnVal;
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }

    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).getMBeanInfo(objectName);
            }
            return this.getDelegateMBeanServer().getMBeanInfo(objectName);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    public final boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            return false;
        }
        try {
            List<String> instance = this.getInstance(objectName).getInstances();
            if (instance.size() != 1) {
                throw new InstanceNotFoundException(localStrings.getLocalString("interceptor.objectName.wrongservernames", "This mbean call does not support multiple target instances"));
            }
            if (instance.get(0).equals("server")) {
                return this.getDelegateMBeanServer().isRegistered(objectName);
            }
            return this.getInstanceConnection(instance.get(0)).isRegistered(objectName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).addNotificationListener(objectName, notificationListener, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).addNotificationListener(objectName, notificationListener, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).addNotificationListener(objectName, objectName1, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().addNotificationListener(objectName, objectName1, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).addNotificationListener(objectName, objectName1, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName);
            }
            return ret;
        }
        catch (Exception ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName, objectName2);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName, objectName2);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName, objectName2);
            }
            return ret;
        }
        catch (Exception ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName, obj, str3);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName, obj, str3);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName, obj, str3);
            }
            return ret;
        }
        catch (Exception ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName, objectName2, obj, str4);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName, objectName2, obj, str4);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName, objectName2, obj, str4);
            }
            return ret;
        }
        catch (Exception ioex) {
            throw new MBeanException(ioex);
        }
    }

    public final ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, values);
    }

    public final ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        return this.getDelegateMBeanServer().deserialize(objectName, values);
    }

    public final ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, objectName, values);
    }

    public final String getDefaultDomain() {
        return this.getDelegateMBeanServer().getDefaultDomain();
    }

    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        List<String> instance = this.getInstance(objectName).getInstances();
        if (instance.size() != 1) {
            throw new InstanceNotFoundException(localStrings.getLocalString("interceptor.objectName.wrongservernames", "This mbean call does not support multiple target instances"));
        }
        if (instance.get(0).equals("server")) {
            return this.getDelegateMBeanServer().getObjectInstance(objectName);
        }
        try {
            return this.getInstanceConnection(instance.get(0)).getObjectInstance(objectName);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final Object instantiate(String str) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str);
    }

    public final Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().instantiate(str, objectName);
    }

    public final Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str, obj, str2);
    }

    public final Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().instantiate(str, objectName, obj, str3);
    }

    public final boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        List<String> instance = this.getInstance(objectName).getInstances();
        if (instance.size() != 1) {
            throw new InstanceNotFoundException(localStrings.getLocalString("interceptor.objectName.wrongservernames", "This mbean call does not support multiple target instances"));
        }
        if (instance.get(0).equals("server")) {
            return this.getDelegateMBeanServer().isInstanceOf(objectName, str);
        }
        try {
            return this.getInstanceConnection(instance.get(0)).isInstanceOf(objectName, str);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (objectName == null) {
            return Collections.EMPTY_SET;
        }
        try {
            Set<ObjectName> returnVal = null;
            List<String> instance = this.getInstance(objectName).getInstances();
            for (String ins : instance) {
                Set<ObjectName> tmp = ins.equals("server") ? this.getDelegateMBeanServer().queryNames(objectName, queryExp) : this.getInstanceConnection(ins).queryNames(objectName, queryExp);
                if (returnVal == null) {
                    returnVal = tmp;
                    continue;
                }
                returnVal.addAll(tmp);
            }
            return returnVal;
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, objectName1);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, objectName1);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, notificationListener);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, notificationListener);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, objectName1, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, objectName1, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().getClassLoader(objectName);
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().getClassLoaderFor(objectName);
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        return this.getDelegateMBeanServer().getClassLoaderRepository();
    }

    public final String[] getDomains() {
        return this.getDelegateMBeanServer().getDomains();
    }

    static {
        localStrings = new LocalStringManagerImpl(DynamicInterceptor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplicationInfo {
        private boolean instanceTarget = false;
        private List<String> instances = new ArrayList<String>();

        private ReplicationInfo() {
        }

        boolean isTargetAnInstance() {
            return this.instanceTarget;
        }

        void setTargetIsAnInstance(boolean b) {
            this.instanceTarget = b;
        }

        List<String> getInstances() {
            return this.instances;
        }

        void addInstance(String s) {
            this.instances.add(s);
        }
    }
}

