/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Dom;

@Service(name="list")
@Scoped(value=PerLookup.class)
public class ListCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    Target targetService;
    @Inject
    Habitat habitat;
    @Param(name="MoniTor", optional=true, defaultValue="false", shortName="m", alias="Mon")
    Boolean monitor;
    @Param(primary=true)
    String pattern = "";
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry mrdr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.listMonitorElements(report, context);
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(matchingNodes);
        for (Map.Entry node : matchingNodesSorted) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setChildrenType("DottedName");
            part.setMessage(prefix + (String)node.getValue());
        }
    }

    private void listMonitorElements(ActionReport report, AdminCommandContext ctxt) {
        if (this.pattern == null || this.pattern.equals("")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("match pattern is invalid or null");
            return;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("monitoring facility not installed");
            return;
        }
        String targetName = this.pattern.indexOf(".") == -1 ? this.pattern : this.pattern.substring(0, this.pattern.indexOf("."));
        if (!this.serverEnv.getInstanceName().equals(targetName)) {
            this.callInstance(report, ctxt, targetName);
            return;
        }
        TreeNode tn = this.mrdr.get(targetName);
        if (tn == null) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        List<TreeNode> ltn = this.sortTreeNodesByCompletePathName(tn.getNodes(this.pattern));
        for (TreeNode tn1 : ltn) {
            if (!tn1.hasChildNodes()) continue;
            System.out.println(tn1.getCompletePathName());
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(tn1.getCompletePathName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void callInstance(ActionReport report, AdminCommandContext context, String targetName) {
        try {
            ParameterMap paramMap = new ParameterMap();
            paramMap.set("MoniTor", "true");
            paramMap.set("DEFAULT", this.pattern);
            List targetList = this.targetService.getInstances(targetName);
            ClusterOperationUtil.replicateCommand((String)"list", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (List)targetList, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
        }
        catch (Exception ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Failure while trying get details from instance " + targetName);
        }
    }
}

