/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class Version
implements PostConstruct {
    private static final String product_name = "GlassFish Server Open Source Edition";
    private static final String abbrev_product_name = "glassfish";
    private static String full_version = "3.1-b25";
    private static final String major_version = "3";
    private static final String minor_version = "1";
    private static final String update_version = "";
    private static final String build_id = "java_re-private";
    private static final String version_prefix = "";
    private static final String version_suffix = "";
    private static Branding br = null;
    @Inject
    private static Habitat mHabitat;

    public static void setBranding(Branding b) {
        br = b;
    }

    public void postConstruct() {
        if (br == null && mHabitat != null) {
            br = (Branding)mHabitat.getByContract(Branding.class);
        }
        if (minor_version != null && minor_version.length() > 0) {
            try {
                if (Integer.parseInt(minor_version) > 0) {
                    if ("".length() > 0) {
                        if (Integer.parseInt("") > 0) {
                            full_version = "3.1.";
                        }
                    } else {
                        full_version = "3.1";
                    }
                } else if ("".length() > 0) {
                    if (Integer.parseInt("") > 0) {
                        full_version = "3.1.";
                    }
                } else {
                    full_version = major_version;
                }
            }
            catch (NumberFormatException nfe) {
                full_version = major_version;
            }
        }
    }

    public static String getVersion() {
        if (br != null) {
            return br.getVersion();
        }
        if (product_name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(product_name);
        if (Version.ok("")) {
            sb.append(" ").append("");
        }
        if (full_version != null) {
            sb.append(" ").append(full_version);
        }
        if (Version.ok("")) {
            sb.append(" ").append("");
        }
        return sb.toString();
    }

    public static String getFullVersion() {
        if (br != null) {
            return br.getFullVersion();
        }
        return Version.getVersion() + " (build " + build_id + ")";
    }

    public static String getAbbreviatedVersion() {
        if (br != null) {
            return br.getAbbreviatedVersion();
        }
        return abbrev_product_name;
    }

    public static String getMajorVersion() {
        if (br != null) {
            return br.getMajorVersion();
        }
        return major_version;
    }

    public static String getMinorVersion() {
        if (br != null) {
            return br.getMinorVersion();
        }
        return minor_version;
    }

    public static String getUpdateVersion() {
        if (br != null) {
            return br.getUpdateVersion();
        }
        return "";
    }

    public static String getBuildVersion() {
        if (br != null) {
            return br.getBuildVersion();
        }
        return build_id;
    }

    public static String getVersionPrefix() {
        if (br != null) {
            return br.getVersionPrefix();
        }
        return "";
    }

    public static String getVersionSuffix() {
        if (br != null) {
            return br.getVersionSuffix();
        }
        return "";
    }

    public static String getProductName() {
        if (br != null) {
            return br.getProductName();
        }
        return product_name;
    }

    public static String getAbbrevProductName() {
        if (br != null) {
            return br.getAbbrevProductName();
        }
        return abbrev_product_name;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

