/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherConstants;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.GFLauncherNativeHelper;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.OS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GFLauncher {
    private List<String> commandLine = new ArrayList<String>();
    private GFLauncherInfo info;
    private Map<String, String> asenvProps;
    private JavaConfig javaConfig;
    private JvmOptions jvmOptions;
    private Profiler profiler;
    private Map<String, String> sysPropsFromXml;
    private String javaExe;
    private String classpath;
    private List<String> debugOptions;
    private long startTime;
    private String logFilename;
    private LaunchType mode = LaunchType.normal;
    private static final LocalStringsImpl strings = new LocalStringsImpl(GFLauncher.class);
    private boolean setupCalledByClients = false;
    private int exitValue = -1;
    private ProcessWhacker processWhacker;
    private Process process;
    private ProcessStreamDrainer psd;
    private boolean logFilenameWasFixed = false;
    private boolean needsUpgrade = false;

    public final GFLauncherInfo getInfo() {
        return this.info;
    }

    public final synchronized void launch() throws GFLauncherException {
        try {
            this.startTime = System.currentTimeMillis();
            if (!this.setupCalledByClients) {
                this.setup();
            }
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(strings.get("unknownError", t.getMessage()), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public final synchronized void relaunch() throws GFLauncherException {
        this.setupCalledByClients = false;
        this.launch();
    }

    public final synchronized void launchJVM(List<String> cmdsIn) throws GFLauncherException {
        try {
            this.setup();
            LinkedList<String> commands = new LinkedList<String>();
            commands.add(this.javaExe);
            for (String cmd : cmdsIn) {
                commands.add(cmd);
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            Process p = pb.start();
            ProcessStreamDrainer.drain("launchJVM", p);
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(strings.get("unknownError", t.getMessage()), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public synchronized void setup() throws GFLauncherException, MiniXmlParserException {
        ASenvPropertyReader pr = this.isFakeLaunch() ? new ASenvPropertyReader(this.info.getInstallDir()) : new ASenvPropertyReader();
        this.asenvProps = pr.getProps();
        this.info.setup();
        this.setupLogLevels();
        MiniXmlParser parser = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = parser.getDomainName();
        if (GFLauncherUtils.ok(domainName)) {
            this.info.setDomainName(domainName);
        }
        this.info.setAdminAddresses(parser.getAdminAddresses());
        this.javaConfig = new JavaConfig(parser.getJavaConfig());
        this.setupProfilerAndJvmOptions(parser);
        this.setupMonitoring(parser);
        this.sysPropsFromXml = parser.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        this.debugOptions = this.getDebug();
        parser.setupConfigDir(this.getInfo().getConfigDir(), this.getInfo().getInstallDir());
        this.setLogFilename(parser);
        this.resolveAllTokens();
        this.fixLogFilename();
        GFLauncherLogger.addLogFileHandler(this.logFilename, this.info);
        this.setJavaExecutable();
        this.setClasspath();
        this.setCommandLine();
        this.logCommandLine();
        this.needsUpgrade = !parser.hasNetworkConfig();
        this.setupCalledByClients = true;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final Process getProcess() throws GFLauncherException {
        if (this.process == null) {
            throw new GFLauncherException("invalid_process");
        }
        return this.process;
    }

    public final ProcessStreamDrainer getProcessStreamDrainer() throws GFLauncherException {
        if (this.psd == null) {
            throw new GFLauncherException("invalid_psd");
        }
        return this.psd;
    }

    public String getLogFilename() throws GFLauncherException {
        if (!this.logFilenameWasFixed) {
            throw new GFLauncherException(strings.get("internalError") + " call to getLogFilename() before it has been initialized");
        }
        return this.logFilename;
    }

    public final int getDebugPort() {
        for (String opt : this.debugOptions) {
            String[] attrs;
            if (!opt.startsWith("-Xrunjdwp:")) continue;
            for (String attr : attrs = opt.substring(10).split(",")) {
                if (!attr.startsWith("address=")) continue;
                try {
                    return Integer.parseInt(attr.substring(8));
                }
                catch (NumberFormatException ex) {
                    return -1;
                }
            }
        }
        return -1;
    }

    public final boolean needsUpgrade() {
        return this.needsUpgrade;
    }

    abstract void internalLaunch() throws GFLauncherException;

    private void setLogFilename(MiniXmlParser parser) throws GFLauncherException {
        this.logFilename = parser.getLogFilename();
        if (this.logFilename == null) {
            this.logFilename = "logs/server.log";
        }
    }

    private void fixLogFilename() throws GFLauncherException {
        boolean wasCreated;
        File parent;
        File f;
        if (!GFLauncherUtils.ok(this.logFilename)) {
            this.logFilename = "logs/server.log";
        }
        if (!(f = new File(this.logFilename)).isAbsolute()) {
            f = new File(this.info.getInstanceRootDir(), this.logFilename);
        }
        if (!((f = SmartFile.sanitize(f)).exists() || (parent = f.getParentFile()).isDirectory() || (wasCreated = parent.mkdirs()))) {
            f = null;
        }
        this.logFilename = f == null ? null : f.getPath();
        this.logFilenameWasFixed = true;
    }

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    GFLauncher(GFLauncherInfo info) {
        this.info = info;
    }

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    final List<String> getCommandLine() {
        return this.commandLine;
    }

    final long getStartTime() {
        return this.startTime;
    }

    void launchInstance() throws GFLauncherException, MiniXmlParserException {
        if (this.isFakeLaunch()) {
            return;
        }
        List<String> cmds = this.getCommandLine();
        ProcessBuilder pb = new ProcessBuilder(cmds);
        try {
            File newDir = this.getInfo().getConfigDir();
            pb.directory(newDir);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.closeStandardStreamsMaybe();
            this.process = pb.start();
            this.psd = this.getInfo().isVerbose() ? ProcessStreamDrainer.redirect(this.getInfo().getDomainName(), this.process) : ProcessStreamDrainer.save(this.getInfo().getDomainName(), this.process);
            this.writeSecurityTokens(this.process);
        }
        catch (Exception e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        long endTime = System.currentTimeMillis();
        GFLauncherLogger.info("launchTime", endTime - this.getStartTime());
        if (this.getInfo().isVerbose()) {
            this.wait(this.process);
        }
    }

    private void writeSecurityTokens(Process sp) throws GFLauncherException, IOException {
        this.handleDeadProcess();
        OutputStream os = sp.getOutputStream();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(os));
            for (String token : this.info.securityTokens) {
                bw.write(token);
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            this.handleDeadProcess();
            throw e;
        }
        finally {
            if (bw != null) {
                this.handleDeadProcess();
                bw.close();
            }
        }
    }

    private void handleDeadProcess() throws GFLauncherException {
        String trace = this.getDeadProcessTrace(this.process);
        if (trace != null) {
            throw new GFLauncherException(trace);
        }
    }

    private String getDeadProcessTrace(Process sp) throws GFLauncherException {
        try {
            int ev = sp.exitValue();
            ProcessStreamDrainer psd = this.getProcessStreamDrainer();
            String output = psd.getOutErrString();
            String trace = strings.get("server_process_died", ev, output);
            return trace;
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    void setCommandLine() throws GFLauncherException {
        List<String> cmdLine = this.getCommandLine();
        cmdLine.clear();
        this.addIgnoreNull(cmdLine, this.javaExe);
        this.addIgnoreNull(cmdLine, "-cp");
        this.addIgnoreNull(cmdLine, this.getClasspath());
        this.addIgnoreNull(cmdLine, this.debugOptions);
        String CLIStartTime = System.getProperty("WALL_CLOCK_START");
        if (CLIStartTime != null && CLIStartTime.length() > 0) {
            cmdLine.add("-DWALL_CLOCK_START=" + CLIStartTime);
        }
        if (this.jvmOptions != null) {
            this.addIgnoreNull(cmdLine, this.jvmOptions.toStringArray());
        }
        GFLauncherNativeHelper nativeHelper = new GFLauncherNativeHelper(this.info, this.javaConfig, this.jvmOptions, this.profiler);
        this.addIgnoreNull(cmdLine, nativeHelper.getCommands());
        this.addIgnoreNull(cmdLine, this.getMainClass());
        try {
            this.addIgnoreNull(cmdLine, this.getInfo().getArgsAsList());
        }
        catch (GFLauncherException gfle) {
            throw gfle;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addIgnoreNull(List<String> list, String s) {
        if (GFLauncherUtils.ok(s)) {
            list.add(s);
        }
    }

    private void addIgnoreNull(List<String> list, Collection<String> ss) {
        if (ss != null && !ss.isEmpty()) {
            list.addAll(ss);
        }
    }

    private void wait(Process p) throws GFLauncherException {
        try {
            this.setShutdownHook(p);
            p.waitFor();
            this.exitValue = p.exitValue();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private synchronized void setShutdownHook(Process p) {
        if (this.processWhacker == null) {
            Runtime runtime = Runtime.getRuntime();
            String msg = strings.get("serverStopped", this.info.getType());
            this.processWhacker = new ProcessWhacker(p, msg);
            runtime.addShutdownHook(new Thread(this.processWhacker));
        } else {
            this.processWhacker.setProcess(p);
        }
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        Map<String, String> envProps = System.getenv();
        Map<String, String> sysProps = CollectionUtils.propertiesToStringMap(System.getProperties());
        all.putAll(envProps);
        all.putAll(this.asenvProps);
        all.putAll(sysProps);
        all.putAll(this.sysPropsFromXml);
        all.putAll(this.jvmOptions.getCombinedMap());
        all.putAll(this.profiler.getConfig());
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.jvmOptions.xProps);
        resolver.resolve(this.jvmOptions.xxProps);
        resolver.resolve(this.jvmOptions.plainProps);
        resolver.resolve(this.jvmOptions.sysProps);
        resolver.resolve(this.javaConfig.getMap());
        resolver.resolve(this.profiler.getConfig());
        resolver.resolve(this.debugOptions);
        this.logFilename = resolver.resolve(this.logFilename);
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.javaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.javaConfig.getEnvClasspath();
        List<File> sysCP = this.javaConfig.getSystemClasspath();
        List<File> prefixCP = this.javaConfig.getPrefixClasspath();
        List<File> suffixCP = this.javaConfig.getSuffixClasspath();
        List<File> profilerCP = this.profiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.setClasspath(GFLauncherUtils.fileListToPathString(all));
    }

    boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok(filename)) {
            return false;
        }
        File f = new File(filename);
        if (!f.isDirectory()) {
            return false;
        }
        f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
        if (f.exists()) {
            this.javaExe = SmartFile.sanitize(f).getPath();
            return true;
        }
        return false;
    }

    private List<String> getDebug() {
        if (this.info.isDebug() || this.javaConfig.isDebugEnabled()) {
            return this.javaConfig.getDebugOptions();
        }
        return Collections.emptyList();
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser parser) throws MiniXmlParserException, GFLauncherException {
        this.profiler = new Profiler(parser.getProfilerConfig(), parser.getProfilerJvmOptions(), parser.getProfilerSystemProperties());
        List<String> rawJvmOptions = parser.getJvmOptions();
        rawJvmOptions.addAll(this.getSpecialSystemProperties());
        if (this.profiler.isEnabled()) {
            rawJvmOptions.addAll(this.profiler.getJvmOptions());
        }
        this.jvmOptions = new JvmOptions(rawJvmOptions);
    }

    private void setupMonitoring(MiniXmlParser parser) throws GFLauncherException {
        if (!parser.isMonitoringEnabled()) {
            return;
        }
        Set<String> plainKeys = this.jvmOptions.plainProps.keySet();
        for (String key : plainKeys) {
            if (!key.startsWith("javaagent:") || (key = key.replace('\\', '/')).indexOf("lib/monitor/btrace-agent.jar") <= 0) continue;
            return;
        }
        try {
            this.jvmOptions.plainProps.put(this.getMonitoringJvmOptionString(), null);
        }
        catch (GFLauncherException gFLauncherException) {
            // empty catch block
        }
    }

    private String getMonitoringJvmOptionString() throws GFLauncherException {
        File jarFile = new File(this.getInfo().getInstallDir(), "lib/monitor/btrace-agent.jar");
        String jarPath = SmartFile.sanitize(jarFile).getPath().replace('\\', '/');
        if (!jarFile.isFile()) {
            throw new GFLauncherException("no_btrace_jar", jarPath);
        }
        return "javaagent:" + jarPath + "=unsafe=true,noServer=true";
    }

    private List<String> getSpecialSystemProperties() throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.aas.installRoot", this.getInfo().getInstallDir().getAbsolutePath());
        props.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getAbsolutePath());
        return this.propsToJvmOptions(props);
    }

    void logCommandLine() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.commandLine) {
            sb.append(GFLauncherConstants.NEWLINE);
            sb.append(s);
        }
        if (!this.isFakeLaunch()) {
            GFLauncherLogger.info("commandline", sb.toString());
        }
    }

    String getClasspath() {
        return this.classpath;
    }

    void setClasspath(String s) {
        this.classpath = s;
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> ss = new ArrayList<String>();
        Set<String> set = map.keySet();
        for (String name : set) {
            String value = map.get(name);
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            ss.add(jvm);
        }
        return ss;
    }

    private void setupLogLevels() {
        if (this.info.isVerbose()) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    private void closeStandardStreamsMaybe() {
        if (System.console() == null && OS.isWindows() && !this.info.isVerbose()) {
            System.out.println(strings.get("ssh"));
            try {
                System.in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                System.err.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                System.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ProcessWhacker
    implements Runnable {
        private String message;
        private Process process;

        ProcessWhacker(Process p, String msg) {
            this.message = msg;
            this.process = p;
        }

        void setProcess(Process p) {
            this.process = p;
        }

        public void run() {
            System.out.println(this.message);
            this.process.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }
}

