/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.config.GrizzlyEmbeddedHttps;
import com.sun.grizzly.config.SecurePasswordProvider;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLConfigHolder {
    private static final String PLAIN_PASSWORD_PROVIDER_NAME = "plain";
    private static final Logger LOGGER = GrizzlyEmbeddedHttps.logger();
    protected SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    protected String[] enabledCipherSuites = null;
    protected String[] enabledProtocols = null;
    protected boolean clientMode = false;
    protected boolean needClientAuth = false;
    protected boolean wantClientAuth = false;
    private final Ssl ssl;

    public SSLConfigHolder(Ssl ssl) throws SSLException {
        this.ssl = ssl;
        this.sslImplementation = SSLConfigHolder.lookupSSLImplementation(ssl);
        if (this.sslImplementation == null) {
            throw new SSLException("Can not configure SSLImplementation");
        }
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "newSSLEngine: {0}", sslEngine);
        }
        if (this.enabledCipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.setNeedClientAuth(this.needClientAuth);
        return sslEngine;
    }

    public boolean configureSSL() {
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        try {
            this.initializeSSL();
            if (this.ssl != null) {
                String[] ciphers;
                String ssl2Ciphers;
                if (Boolean.parseBoolean(this.ssl.getClientAuthEnabled())) {
                    this.needClientAuth = true;
                }
                if (Boolean.parseBoolean(this.ssl.getSsl2Enabled())) {
                    tmpSSLArtifactsList.add("SSLv2");
                }
                if (Boolean.parseBoolean(this.ssl.getSsl3Enabled())) {
                    tmpSSLArtifactsList.add("SSLv3");
                }
                if (Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
                    tmpSSLArtifactsList.add("TLSv1");
                }
                if (Boolean.parseBoolean(this.ssl.getSsl3Enabled()) || Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
                    tmpSSLArtifactsList.add("SSLv2Hello");
                }
                if (tmpSSLArtifactsList.isEmpty()) {
                    this.logEmptyWarning(this.ssl, "WEB0307: All SSL protocol variants disabled for network-listener {0}, using SSL implementation specific defaults");
                } else {
                    String[] protocols = new String[tmpSSLArtifactsList.size()];
                    tmpSSLArtifactsList.toArray(protocols);
                    this.enabledProtocols = protocols;
                }
                String auth = this.ssl.getClientAuth();
                if (auth != null) {
                    if ("want".equalsIgnoreCase(auth.trim())) {
                        this.wantClientAuth = true;
                    } else if ("need".equalsIgnoreCase(auth.trim())) {
                        this.needClientAuth = true;
                    }
                }
                tmpSSLArtifactsList.clear();
                String ssl3Ciphers = this.ssl.getSsl3TlsCiphers();
                if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
                    String[] ssl3CiphersArray;
                    for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                        tmpSSLArtifactsList.add(cipher.trim());
                    }
                }
                if ((ssl2Ciphers = this.ssl.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
                    String[] ssl2CiphersArray;
                    for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                        tmpSSLArtifactsList.add(cipher.trim());
                    }
                }
                if ((ciphers = SSLConfigHolder.getJSSECiphers(tmpSSLArtifactsList)) == null || ciphers.length == 0) {
                    this.logEmptyWarning(this.ssl, "WEB0308: All SSL cipher suites disabled for network-listener(s) {0}.  Using SSL implementation specific defaults");
                } else {
                    this.enabledCipherSuites = ciphers;
                }
            }
            return true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
            return false;
        }
    }

    protected void logEmptyWarning(Ssl ssl, String msg) {
        StringBuilder name = new StringBuilder();
        for (NetworkListener listener : ((Protocol)ssl.getParent()).findNetworkListeners()) {
            if (name.length() != 0) {
                name.append(", ");
            }
            name.append(listener.getName());
        }
        LOGGER.log(Level.FINE, msg, name.toString());
    }

    private void initializeSSL() throws Exception {
        SSLImplementation sslHelper = this.getSSLImplementation();
        ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
        if (this.ssl != null) {
            if (this.ssl.getCrlFile() != null) {
                SSLConfigHolder.setAttribute(serverSF, "crlFile", this.ssl.getCrlFile(), null, null);
            }
            if (this.ssl.getTrustAlgorithm() != null) {
                SSLConfigHolder.setAttribute(serverSF, "truststoreAlgorithm", this.ssl.getTrustAlgorithm(), null, null);
            }
            if (this.ssl.getKeyAlgorithm() != null) {
                SSLConfigHolder.setAttribute(serverSF, "algorithm", this.ssl.getKeyAlgorithm(), null, null);
            }
            SSLConfigHolder.setAttribute(serverSF, "trustMaxCertLength", this.ssl.getTrustMaxCertLength(), null, null);
        }
        SSLConfigHolder.setAttribute(serverSF, "keystore", this.ssl != null ? this.ssl.getKeyStore() : null, "javax.net.ssl.keyStore", null);
        SSLConfigHolder.setAttribute(serverSF, "keystoreType", this.ssl != null ? this.ssl.getKeyStoreType() : null, "javax.net.ssl.keyStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "keystorePass", this.ssl != null ? SSLConfigHolder.getKeyStorePassword(this.ssl) : null, "javax.net.ssl.keyStorePassword", "changeit");
        SSLConfigHolder.setAttribute(serverSF, "truststore", this.ssl != null ? this.ssl.getTrustStore() : null, "javax.net.ssl.trustStore", null);
        SSLConfigHolder.setAttribute(serverSF, "truststoreType", this.ssl != null ? this.ssl.getTrustStoreType() : null, "javax.net.ssl.trustStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "truststorePass", this.ssl != null ? SSLConfigHolder.getTrustStorePassword(this.ssl) : null, "javax.net.ssl.trustStorePassword", "changeit");
        serverSF.setAttribute("keyAlias", this.ssl != null ? this.ssl.getCertNickname() : null);
        serverSF.init();
        this.sslContext = serverSF.getSSLContext();
        CipherInfo.updateCiphers(this.sslContext);
    }

    public static boolean isAllowLazyInit(Ssl ssl) {
        return ssl == null || Boolean.parseBoolean(ssl.getAllowLazyInit());
    }

    private static void setAttribute(ServerSocketFactory serverSF, String name, String value, String property, String defaultValue) {
        serverSF.setAttribute(name, (Object)(value == null ? System.getProperty(property, defaultValue) : value));
    }

    private static String getKeyStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getKeyStorePasswordProvider())) {
            return ssl.getKeyStorePassword();
        }
        return SSLConfigHolder.getStorePasswordCustom(ssl.getKeyStorePassword());
    }

    private static String getTrustStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getTrustStorePasswordProvider())) {
            return ssl.getTrustStorePassword();
        }
        return SSLConfigHolder.getStorePasswordCustom(ssl.getTrustStorePassword());
    }

    private static String getStorePasswordCustom(String storePasswordProvider) {
        block3: {
            try {
                SecurePasswordProvider provider = (SecurePasswordProvider)Utils.newInstance(storePasswordProvider);
                if (provider != null) {
                    return provider.getPassword();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SECURE_PASSWORD_INITIALIZATION_ERROR((Object)storePasswordProvider), e);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SSLImplementation lookupSSLImplementation(Ssl ssl) {
        String sslImplClassName = ssl.getClassname();
        if (sslImplClassName == null) return SSLImplementation.getInstance();
        try {
            SSLImplementation impl;
            Class<?> clazz;
            ClassLoader cl = SSLConfigHolder.getContextClassLoader();
            if (cl != null) {
                try {
                    clazz = Class.forName(sslImplClassName, false, cl);
                }
                catch (ClassNotFoundException ex) {
                    clazz = Class.forName(sslImplClassName);
                }
            } else {
                clazz = Class.forName(sslImplClassName);
            }
            if ((impl = (SSLImplementation)clazz.newInstance()) != null) {
                return impl;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) return SSLImplementation.getInstance();
            LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SSL_IMPLEMENTATION_LOAD_ERROR((Object)sslImplClassName));
            return SSLImplementation.getInstance();
        }
        catch (Exception e) {
            try {
                if (!LOGGER.isLoggable(Level.SEVERE)) return SSLImplementation.getInstance();
                LOGGER.log(Level.SEVERE, LogMessages.SEVERE_GRIZZLY_CONFIG_SSL_CLASS_LOAD_FAILED_ERROR((Object)sslImplClassName), e);
                return SSLImplementation.getInstance();
            }
            catch (Exception e2) {
                if (!LOGGER.isLoggable(Level.WARNING)) return null;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e2);
                return null;
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    private static String[] getJSSECiphers(List<String> configuredCiphers) {
        HashSet<String> enabledCiphers = null;
        for (String cipher : configuredCiphers) {
            String jsseCipher;
            if (cipher.length() <= 0 || cipher.charAt(0) == '-') continue;
            if (cipher.charAt(0) == '+') {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = SSLConfigHolder.getJSSECipher(cipher)) == null) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_UNKNOWN_CIPHER_ERROR((Object)cipher));
                continue;
            }
            if (enabledCiphers == null) {
                enabledCiphers = new HashSet<String>(configuredCiphers.size());
            }
            enabledCiphers.add(jsseCipher);
        }
        return enabledCiphers == null ? null : enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    private static String getJSSECipher(String cipher) {
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        return ci != null ? ci.getCipherName() : null;
    }

    private static final class CipherInfo {
        private static final short SSL2 = 1;
        private static final short SSL3 = 2;
        private static final short TLS = 4;
        private static final String[][] OLD_CIPHER_MAPPING = new String[][]{{"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_MD5"}, {"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA"}};
        private static final Map<String, CipherInfo> ciphers = new HashMap<String, CipherInfo>();
        private final String configName;
        private final String cipherName;
        private final short protocolVersion;

        private CipherInfo(String configName, String cipherName, short protocolVersion) {
            this.configName = configName;
            this.cipherName = cipherName;
            this.protocolVersion = protocolVersion;
        }

        public static void updateCiphers(SSLContext sslContext) {
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            for (String s : factory.getDefaultCipherSuites()) {
                ciphers.put(s, new CipherInfo(s, s, 6));
            }
        }

        public static CipherInfo getCipherInfo(String configName) {
            return ciphers.get(configName);
        }

        public String getCipherName() {
            return this.cipherName;
        }

        public boolean isSSL2() {
            return (this.protocolVersion & 1) == 1;
        }

        public boolean isSSL3() {
            return (this.protocolVersion & 2) == 2;
        }

        public boolean isTLS() {
            return (this.protocolVersion & 4) == 4;
        }

        static {
            int len = OLD_CIPHER_MAPPING.length;
            for (int i = 0; i < len; ++i) {
                String nonStdName = OLD_CIPHER_MAPPING[i][0];
                String stdName = OLD_CIPHER_MAPPING[i][1];
                ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 6));
            }
        }
    }
}

