/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.deployment.versioning.VersioningWildcardException;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-application-ref")
@I18n(value="create.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class CreateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true, acceptableValues="true,false")
    public String lbenabled;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    private Habitat habitat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        report = context.getActionReport();
        logger = context.getLogger();
        matchedVersions = null;
        if (this.enabled.booleanValue()) {
            try {
                VersioningUtils.checkIdentifier((String)this.name);
                matchedVersions = new ArrayList<String>(1);
                matchedVersions.add(this.name);
            }
            catch (VersioningWildcardException ex) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("wildcard.not.allowed", "WARNING : version expression are available only with --enabled=false"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            catch (VersioningSyntaxException ex) {
                report.setMessage(ex.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.deployment.isRegistered(this.name)) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            try {
                matchedVersions = this.versioningService.getMatchedVersions(this.name, null);
            }
            catch (VersioningException e) {
                report.failure(logger, e.getMessage());
                return;
            }
            if (matchedVersions.isEmpty()) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        part = report.getTopMessagePart();
        isVersionExpression = VersioningUtils.isVersionExpression((String)this.name);
        it = matchedVersions.iterator();
        while (it.hasNext() != false) {
            appName = (String)it.next();
            app = this.applications.getApplication(appName);
            applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef != null) {
                if (!isVersionExpression) {
                    report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{this.name, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                childPart = part.addChild();
                childPart.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{appName, this.target}));
                continue;
            }
            t = new Transaction();
            if (app.isLifecycleModule()) {
                this.handleLifecycleModule(context, t);
                return;
            }
            file = null;
            commandParams = null;
            contextProps = new Properties();
            modulePropsMap = null;
            savedAppConfig = null;
            try {
                commandParams = app.getDeployParameters(null);
                commandParams.origin = OpsParams.Origin.load;
                commandParams.target = this.target;
                commandParams.virtualservers = this.virtualservers;
                commandParams.enabled = this.enabled;
                if (this.lbenabled != null) {
                    commandParams.lbenabled = this.lbenabled;
                }
                if (app.containsSnifferType("osgi")) {
                    commandParams.type = "osgi";
                }
                contextProps = app.getDeployProperties();
                modulePropsMap = app.getModulePropertiesMap();
                savedAppConfig = new ApplicationConfigInfo(app);
                uri = new URI(app.getLocation());
                file = new File(uri);
                if (!file.exists()) {
                    report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                archive = this.archiveFactory.openArchive(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                block34: {
                    deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
                    appProps = deploymentContext.getAppProps();
                    appProps.putAll((Map<?, ?>)contextProps);
                    location = DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(app.getLocation()));
                    appProps.setProperty("location", location);
                    appLocation = appProps.getProperty("appLocation");
                    appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(appLocation)));
                    planLocation = appProps.getProperty("deploymentPlanLocation");
                    if (planLocation != null) {
                        appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(planLocation)));
                    }
                    savedAppConfig.store(appProps);
                    if (modulePropsMap != null) {
                        deploymentContext.setModulePropsMap(modulePropsMap);
                    }
                    if (this.enabled.booleanValue()) {
                        this.versioningService.handleDisable(appName, this.target, deploymentContext.getActionReport());
                    }
                    if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null)) {
                        this.deployment.deploy((Collection)this.deployment.getSniffersFromApp(app), deploymentContext);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        try {
                            this.deployment.registerAppInDomainXML(null, (DeploymentContext)deploymentContext, t, true);
                        }
                        catch (TransactionFailure e) {
                            logger.warning("failed to create application ref for " + appName);
                        }
                    }
                    if (isVersionExpression || !DeploymentUtils.isDASTarget((String)this.target)) break block34;
                    var26_31 = null;
                    ** GOTO lbl143
                }
                paramMap = this.deployment.prepareInstanceDeployParamMap((DeploymentContext)deploymentContext);
                targets = new ArrayList<String>(Arrays.asList(commandParams.target.split(",")));
                ClusterOperationUtil.replicateCommand((String)"_deploy", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
                ** GOTO lbl149
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during creating application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                var26_31 = null;
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                continue;
            }
            {
                catch (Throwable var25_33) {
                    var26_31 = null;
                    ** try [egrp 6[TRYBLOCK] [12 : 1104->1114)] { 
lbl138:
                    // 1 sources

                    archive.close();
                    throw var25_33;
lbl140:
                    // 1 sources

                    catch (IOException e) {
                        logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                    }
                    throw var25_33;
                }
lbl143:
                // 1 sources

                ** try [egrp 6[TRYBLOCK] [12 : 1104->1114)] { 
lbl144:
                // 1 sources

                archive.close();
                return;
lbl146:
                // 1 sources

                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                return;
lbl149:
                // 1 sources

                var26_31 = null;
                try {}
                catch (IOException e) {}
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                continue;
                archive.close();
            }
        }
    }

    private void handleLifecycleModule(AdminCommandContext context, Transaction t) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        Application app = this.applications.getApplication(this.name);
        DeployCommandParameters commandParams = new DeployCommandParameters();
        commandParams.name = this.name;
        commandParams.target = this.target;
        commandParams.virtualservers = this.virtualservers;
        commandParams.enabled = this.enabled;
        DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, logger, null, (OpsParams)commandParams, null);
        try {
            this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t, true);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
        if (!DeploymentUtils.isDASTarget((String)this.target)) {
            ParameterMap paramMap = new ParameterMap();
            paramMap.add((Object)"DEFAULT", (Object)this.name);
            paramMap.add((Object)"target", (Object)this.target);
            paramMap.add((Object)"enabled", (Object)this.enabled.toString());
            if (this.virtualservers != null) {
                paramMap.add((Object)"virtualservers", (Object)this.virtualservers);
            }
            Properties appProps = app.getDeployProperties();
            paramMap.set((Object)"appprops", (Object)DeploymentUtils.propertiesValue((Properties)appProps, (char)':'));
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(this.target);
            ClusterOperationUtil.replicateCommand((String)"_lifecycle", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
        }
    }
}

