/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class AuthTokenManager {
    public static final String AUTH_TOKEN_OPTION = "--authtoken";
    private static final int TOKEN_SIZE = 10;
    private final SecureRandom rng = new SecureRandom();
    private final Map<String, AtomicInteger> liveTokens = new HashMap<String, AtomicInteger>();
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String createToken() {
        byte[] newToken = new byte[10];
        this.rng.nextBytes(newToken);
        String token = AuthTokenManager.toHex(newToken);
        this.liveTokens.put(token, new AtomicInteger(2));
        return token;
    }

    public boolean consumeToken(String token) {
        boolean isReusedToken = token.endsWith("+");
        String storedToken = isReusedToken ? token.substring(0, token.length() - 1) : token;
        return this.liveTokens.containsKey(storedToken);
    }

    private static String toHex(byte[] b) {
        char[] bc = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            byte bb = b[i];
            bc[j++] = hex[bb >> 4 & 0xF];
            bc[j++] = hex[bb & 0xF];
        }
        return new String(bc);
    }
}

