/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.LegacyConfigurationUpgrade;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="set")
@ExecuteOn(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@I18n(value="set")
public class SetCommand
extends V2DottedNameSupport
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    ConfigSupport config;
    @Inject
    Target targetService;
    @Param(primary=true, multiple=true)
    String[] values;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetCommand.class);
    private HashMap<String, Integer> targetLevel = null;

    public void postConstruct() {
        this.targetLevel = new HashMap();
        this.targetLevel.put("applications", 0);
        this.targetLevel.put("system-applications", 0);
        this.targetLevel.put("resources", 0);
        this.targetLevel.put("configs", 3);
        this.targetLevel.put("clusters", 3);
        this.targetLevel.put("servers", 3);
        this.targetLevel.put("nodes", 3);
    }

    public void execute(AdminCommandContext context) {
        for (String value : this.values) {
            if (value.contains(".log-service.")) {
                SetCommand.fail(context, localStrings.getLocalString("n", "For setting log levels use set-log-levels command."));
                return;
            }
            if (this.set(context, value)) continue;
            return;
        }
    }

    private boolean set(AdminCommandContext context, String nameval) {
        int i = nameval.indexOf(61);
        if (i < 0) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.namevalue", "Invalid name value pair {0}. Missing expected equal sign.", new Object[]{nameval}));
            return false;
        }
        String target = nameval.substring(0, i);
        String value = nameval.substring(i + 1);
        int lastDotIndex = SetCommand.trueLastIndexOf(target, '.');
        if (lastDotIndex == -1) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.attributename", "Invalid attribute name {0}", new Object[]{target}));
            return false;
        }
        String attrName = target.substring(lastDotIndex + 1).replace("\\.", ".");
        String pattern = target.substring(0, lastDotIndex);
        if (attrName.replace('_', '-').equals("jndi-name")) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.reject.keychange", "Cannot change a primary key\nChange of {0}", new Object[]{target}));
            return false;
        }
        boolean isProperty = false;
        if ("property".equals(pattern.substring(SetCommand.trueLastIndexOf(pattern, '.') + 1))) {
            pattern = target.replaceAll("\\\\\\.", "\\.");
            isProperty = true;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = pattern.substring(0, pattern.indexOf(parentNodes[0].relativeName));
        }
        pattern = parentNodes[0].relativeName;
        String targetName = prefix + pattern;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, pattern);
        if (matchingNodes.isEmpty() && (pattern = target.substring(0, SetCommand.trueLastIndexOf(target, '.'))).endsWith("property")) {
            V2DottedNameSupport.TreeNode parentNode;
            pattern = pattern.substring(0, SetCommand.trueLastIndexOf(pattern, '.'));
            parentNodes = this.getAliasedParent(this.domain, pattern);
            pattern = parentNodes[0].relativeName;
            matchingNodes = this.getMatchingNodes(dottedNames, pattern);
            if (matchingNodes.isEmpty()) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            parentNode = null;
            for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
                if (!node.getValue().equals(pattern)) continue;
                parentNode = node.getKey();
            }
            if (parentNode == null) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("value", value);
            attributes.put("name", attrName);
            try {
                ConfigSupport.createAndSet((ConfigBean)((ConfigBean)parentNode), Property.class, attributes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
                return !this.targetService.isThisDAS() || this.replicateSetCommand(context, targetName, value);
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        }
        HashMap changes = new HashMap();
        boolean delPropertySuccess = false;
        boolean delProperty = false;
        HashMap<String, String> attrChanges = new HashMap<String, String>();
        if (isProperty) {
            attrName = "value";
            if (value == null || value.length() == 0) {
                delProperty = true;
            }
            attrChanges.put(attrName, value);
        }
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            Dom targetNode = node.getKey();
            for (String name : targetNode.model.getAttributeNames()) {
                String finalDottedName = node.getValue() + "." + name;
                if (!this.matches(finalDottedName, pattern) || !attrName.equals(name) && !attrName.replace('_', '-').equals(name.replace('_', '-'))) continue;
                if (this.isDeprecatedAttr(targetNode, name)) {
                    this.warning(context, localStrings.getLocalString("admin.set.deprecated", "Warning: The attribute {0} is deprecated.", new Object[]{targetName}));
                }
                if (!isProperty) {
                    targetName = prefix + finalDottedName;
                    if (value != null && value.length() > 0) {
                        attrChanges.put(name, value);
                    } else {
                        attrChanges.put(name, null);
                    }
                } else {
                    targetName = prefix + node.getValue();
                }
                if (delProperty) {
                    String str = node.getValue();
                    if (SetCommand.trueLastIndexOf(str, '.') != -1) {
                        str = str.substring(SetCommand.trueLastIndexOf(str, '.') + 1);
                    }
                    try {
                        if (str == null) continue;
                        ConfigSupport.deleteChild((ConfigBean)((ConfigBean)targetNode.parent()), (ConfigBean)((ConfigBean)targetNode));
                        delPropertySuccess = true;
                        continue;
                    }
                    catch (IllegalArgumentException ie) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.delete.property.failure", "Could not delete the property: {0}", new Object[]{ie.getMessage()}), ie);
                        return false;
                    }
                    catch (TransactionFailure transactionFailure) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                        return false;
                    }
                }
                changes.put((ConfigBean)node.getKey(), attrChanges);
            }
        }
        if (!changes.isEmpty()) {
            try {
                this.config.apply(changes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        } else if (delPropertySuccess) {
            this.success(context, targetName, value);
        } else {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
            return false;
        }
        return !this.targetService.isThisDAS() || this.replicateSetCommand(context, targetName, value);
    }

    private boolean isDeprecatedAttr(Dom dom, String name) {
        if (dom == null || dom.model == null || name == null) {
            return false;
        }
        Class t = dom.getProxyType();
        if (t == null) {
            return false;
        }
        for (Method method : t.getDeclaredMethods()) {
            ConfigModel.Property p = dom.model.toProperty(method);
            if (p == null || !name.equals(p.xmlName())) continue;
            return method.isAnnotationPresent(Deprecated.class);
        }
        for (AccessibleObject accessibleObject : t.getDeclaredFields()) {
            if (!name.equals(dom.model.camelCaseToXML(((Field)accessibleObject).getName()))) continue;
            return accessibleObject.isAnnotationPresent(Deprecated.class);
        }
        return false;
    }

    private String getElementFromString(String name, int index) {
        StringTokenizer token = new StringTokenizer(name, ".");
        String target = null;
        for (int j = 0; j < index; ++j) {
            if (!token.hasMoreTokens()) continue;
            target = token.nextToken();
        }
        return target;
    }

    private boolean replicateSetCommand(AdminCommandContext context, String targetName, String value) {
        String firstElementOfName = targetName.substring(0, targetName.indexOf(46));
        Integer targetElementLocation = this.targetLevel.get(firstElementOfName);
        if (targetElementLocation == null) {
            targetElementLocation = 1;
        }
        List replicationInstances = null;
        if (targetElementLocation == 0) {
            if ("resources".equals(firstElementOfName)) {
                replicationInstances = this.targetService.getAllInstances();
            }
            if ("applications".equals(firstElementOfName)) {
                String appName = this.getElementFromString(targetName, 3);
                if (appName == null) {
                    SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.appname", "Unable to extract application name from {0}", new Object[]{targetName}));
                    return false;
                }
                replicationInstances = this.targetService.getInstances(this.domain.getAllReferencedTargetsForApplication(appName));
            }
        } else {
            String target = this.getElementFromString(targetName, targetElementLocation);
            if (target == null) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.target", "Unable to extract replication target from {0}", new Object[]{targetName}));
                return false;
            }
            replicationInstances = this.targetService.getInstances(target);
        }
        if (!replicationInstances.isEmpty()) {
            ParameterMap params = new ParameterMap();
            params.set("DEFAULT", targetName + "=" + value);
            ActionReport.ExitCode ret = ClusterOperationUtil.replicateCommand((String)"set", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (List)replicationInstances, (AdminCommandContext)context, (ParameterMap)params, (Habitat)this.habitat);
            if (!ret.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                return false;
            }
        }
        return true;
    }

    private void runLegacyChecks(AdminCommandContext context) {
        Collection list = this.habitat.getAllByContract(LegacyConfigurationUpgrade.class);
        for (LegacyConfigurationUpgrade upgrade : list) {
            upgrade.execute(context);
        }
    }

    private static int trueLastIndexOf(String target, char ch) {
        int i = target.lastIndexOf(ch);
        while (i > 0 && target.charAt(i - 1) == '\\') {
            i = target.lastIndexOf(ch, i - 1);
        }
        return i;
    }

    private static void fail(AdminCommandContext context, String msg) {
        SetCommand.fail(context, msg, null);
    }

    private static void fail(AdminCommandContext context, String msg, Exception ex) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (ex != null) {
            context.getActionReport().setFailureCause(ex);
        }
        context.getActionReport().setMessage(msg);
    }

    private void warning(AdminCommandContext context, String msg) {
        ActionReport ar = context.getActionReport().addSubActionsReport();
        ar.setActionExitCode(ActionReport.ExitCode.WARNING);
        ar.setMessage(msg);
    }

    private void success(AdminCommandContext context, String target, String value) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart part = context.getActionReport().getTopMessagePart().addChild();
        part.setChildrenType("DottedName");
        part.setMessage(target + "=" + value);
    }
}

