/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ServiceInitializerThread;
import com.sun.grizzly.Context;
import com.sun.grizzly.TCPSelectorHandler;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.internal.grizzly.LazyServiceInitializer;

public class ServiceInitializerHandler
extends TCPSelectorHandler {
    private ServiceInitializerThread selectorThread;
    private volatile LazyServiceInitializer targetInitializer = null;
    private Collection<LazyServiceInitializer> initializerImplList = null;
    protected static final Logger logger = Logger.getLogger(ServiceInitializerHandler.class.getName());
    private final Object LOCK_OBJ = new Object();
    private long timeout = 60000L;

    public ServiceInitializerHandler(ServiceInitializerThread selectorThread) {
        this.selectorThread = selectorThread;
        this.initializerImplList = selectorThread.getHabitat().getAllByContract(LazyServiceInitializer.class);
        this.setSelectTimeout(this.timeout);
    }

    public void setSelectorThread(ServiceInitializerThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        if (this.initializerImplList == null) {
            logger.severe("NO Lazy Initialiser was found for port = " + this.selectorThread.getGrizzlyListener().getListener().getPort());
            return false;
        }
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (this.targetInitializer == null) {
            Object object = this.LOCK_OBJ;
            synchronized (object) {
                if (this.targetInitializer == null) {
                    for (LazyServiceInitializer initializer : this.initializerImplList) {
                        String listenerName = this.selectorThread.getGrizzlyListener().getListener().getName();
                        if (!listenerName.equalsIgnoreCase(initializer.getServiceName())) continue;
                        this.targetInitializer = initializer;
                        break;
                    }
                }
                if (this.targetInitializer == null) {
                    logger.severe("NO Lazy Initialiser implementation was found for port = " + this.selectorThread.getGrizzlyListener().getListener().getPort());
                    return false;
                }
                if (!this.targetInitializer.initializeService()) {
                    this.targetInitializer = null;
                    logger.severe("Lazy Service initialization failed for port = " + this.selectorThread.getGrizzlyListener().getListener().getPort());
                    return false;
                }
            }
        }
        if (channel != null) {
            this.targetInitializer.handleRequest(channel);
        }
        return false;
    }
}

