/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class DirectoryClassLoader
extends URLClassLoader {
    private static final LocalStringsImpl strings = new LocalStringsImpl(DirectoryClassLoader.class);

    public DirectoryClassLoader(String dir, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(new File(dir)), parent);
    }

    public DirectoryClassLoader(File dir, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(dir), parent);
    }

    private static URL[] getJars(File dir) throws IOException {
        File[] fjars = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (fjars == null) {
            throw new IOException(strings.get("DirError", new Object[]{dir}));
        }
        URL[] jars = new URL[fjars.length];
        for (int i = 0; i < fjars.length; ++i) {
            jars[i] = fjars[i].toURI().toURL();
        }
        return jars;
    }
}

