/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_get-habitat-info")
@Scoped(value=PerLookup.class)
public class GetHabitatInfo
implements AdminCommand {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry modulesRegistry;
    @Param(primary=true, optional=true)
    String contract = null;
    @Param(optional=true)
    String started = "false";

    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        if (this.contract == null) {
            this.dumpContracts(sb);
        } else {
            this.dumpInhabitantsImplementingContractPattern(this.contract, sb);
        }
        this.dumpModules(sb);
        this.dumpTypes(sb);
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode((String)msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        Iterator it = this.habitat.getAllContracts();
        if (it == null) {
            return;
        }
        TreeSet contracts = new TreeSet();
        while (it.hasNext()) {
            contracts.add(it.next());
        }
        it = contracts.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Contract-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpInhabitantsImplementingContractPattern(String pattern, StringBuilder sb) {
        sb.append("\n*********** List of all services for contract named like " + this.contract + " **************\n");
        Iterator it = this.habitat.getAllContracts();
        while (it.hasNext()) {
            String cn = (String)it.next();
            if (cn.toLowerCase(Locale.ENGLISH).indexOf(pattern.toLowerCase(Locale.ENGLISH)) < 0) continue;
            sb.append("\n-----------------------------\n");
            for (Inhabitant i : this.habitat.getInhabitantsByContract(cn)) {
                sb.append("Inhabitant-Metadata: " + i.metadata().toCommaSeparatedString());
                sb.append("\n");
                boolean isStarted = Boolean.parseBoolean(this.started);
                if (!isStarted) continue;
                sb.append(i.isInstantiated() ? " started" : " not started");
            }
        }
    }

    private void dumpTypes(StringBuilder sb) {
        sb.append("\n\n*********** Sorted List of all Types in the Habitat **************\n\n");
        Iterator it = this.habitat.getAllTypes();
        if (it == null) {
            return;
        }
        TreeSet types = new TreeSet();
        while (it.hasNext()) {
            types.add(it.next());
        }
        it = types.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Type-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpModules(StringBuilder sb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.modulesRegistry.dumpState(new PrintStream(baos));
        sb.append("\n\n*********** List of all Registered Modules **************\n\n");
        sb.append(baos.toString());
    }
}

