/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.logviewer.backend.LogFile;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.server.logging.logviewer.backend.LogRecordTemplate;
import com.sun.enterprise.util.StringUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class LogFilter {
    private static final String RESULTS_ATTRIBUTE = "Results";
    private static final String NV_SEPARATOR = ";";
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServerEnvironment env;
    @Inject
    private Habitat habitat;
    private static final Logger logger = LogDomains.getLogger(LogFilter.class, (String)"javax.enterprise.system.core");
    protected static final String[] LOG_LEVELS = new String[]{"SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static String[] serverLogElements = new String[]{System.getProperty("com.sun.aas.instanceRoot"), "logs", "server.log"};
    private static String pL = System.getProperty("com.sun.aas.processLauncher");
    private static String verboseMode = System.getProperty("com.sun.aas.verboseMode", "false");
    private static String defaultLogFile = System.getProperty("com.sun.aas.defaultLogFile");
    private LogFile _logFile = pL != null && !verboseMode.equals("true") && defaultLogFile != null ? new LogFile(defaultLogFile) : new LogFile(StringUtils.makeFilePath((String[])serverLogElements, (boolean)false));
    private static Hashtable logFileCache = new Hashtable();

    public AttributeList getLogRecordsUsingQuery(String logFileName, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Date fromDate, Date toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        long startingRecord;
        long reqCount;
        LogFile logFile = null;
        if (logFileName != null && logFileName.length() != 0) {
            if (logFileName.contains("${com.sun.aas.instanceRoot}")) {
                String f;
                String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                logFileName = f = logFileName.replace("${com.sun.aas.instanceRoot}", instanceRoot);
            } else {
                logFileName = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "logs" + File.separator + logFileName.trim();
            }
            logFile = this.getLogFile(logFileName);
        } else {
            logFile = this.getLogFile();
        }
        boolean forwd = forward == null ? true : forward;
        boolean nxt = next == null ? true : next;
        long l = reqCount = requestedCount == null ? logFile.getIndexSize() : (long)requestedCount.intValue();
        if (fromRecord == -1L) {
            nxt = forwd;
            startingRecord = forwd ? -1L : (logFile.getLastIndexNumber() + 1L) * logFile.getIndexSize();
        } else {
            startingRecord = fromRecord;
            if (startingRecord < -1L) {
                throw new IllegalArgumentException("fromRecord must be greater than 0!");
            }
        }
        try {
            return this.fetchRecordsUsingQuery(logFile, startingRecord, nxt, forwd, reqCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "logging.backend.error.fetchrecord", ex);
            return new AttributeList();
        }
    }

    public Vector getInstanceLogFileNames(String instanceName) {
        Server targetServer = this.domain.getServerNamed(instanceName);
        Vector allInstanceFileNames = new Vector();
        if (targetServer.isDas()) {
            File[] allLogFileNames;
            File logsDir = new File(this.env.getDomainRoot() + File.separator + "logs");
            for (File file : allLogFileNames = logsDir.listFiles()) {
                String fileName = file.getName();
                if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                allInstanceFileNames.add(fileName);
            }
        } else {
            try {
                allInstanceFileNames = new LogFilterForInstance().getInstanceLogFileNames(this.habitat, targetServer, this.domain, logger, instanceName);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "logging.backend.error.fetchrecord", ex);
                return new Vector();
            }
        }
        return allInstanceFileNames;
    }

    public AttributeList getLogRecordsUsingQuery(String logFileName, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Date fromDate, Date toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch, String instanceName, boolean logFileRefresh) {
        long startingRecord;
        long reqCount;
        Server targetServer = this.domain.getServerNamed(instanceName);
        File instanceLogFile = null;
        if (targetServer.isDas()) {
            return this.getLogRecordsUsingQuery(logFileName, fromRecord, next, forward, requestedCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        String serverNode = targetServer.getNode();
        if (serverNode.equals("localhost") || serverNode.equals("127.0.0.1")) {
            instanceLogFile = new File(this.env.getInstanceRoot().getAbsolutePath() + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + serverNode + File.separator + instanceName + File.separator + "logs" + File.separator + logFileName);
        } else {
            File logFileOnServer = new File(this.env.getDomainRoot().getAbsolutePath() + File.separator + "logs" + File.separator + instanceName + File.separator + logFileName);
            if (!logFileOnServer.exists()) {
                try {
                    instanceLogFile = new LogFilterForInstance().downloadGivenInstanceLogFile(this.habitat, targetServer, this.domain, logger, instanceName, this.env.getDomainRoot().getAbsolutePath(), logFileName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "logging.backend.error.instance", e);
                    return new AttributeList();
                }
            } else if (logFileRefresh) {
                try {
                    instanceLogFile = new LogFilterForInstance().downloadGivenInstanceLogFile(this.habitat, targetServer, this.domain, logger, instanceName, this.env.getDomainRoot().getAbsolutePath(), logFileName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "logging.backend.error.instance", e);
                    return new AttributeList();
                }
            } else {
                instanceLogFile = logFileOnServer;
            }
        }
        LogFile logFile = null;
        File loggingFileExists = new File(instanceLogFile.getAbsolutePath());
        if (!loggingFileExists.exists()) {
            logger.log(Level.WARNING, "logging.backend.error.filenotfound", instanceLogFile.getAbsolutePath());
            return new AttributeList();
        }
        logFile = this.getLogFile(instanceLogFile.getAbsolutePath());
        boolean forwd = forward == null ? true : forward;
        boolean nxt = next == null ? true : next;
        long l = reqCount = requestedCount == null ? logFile.getIndexSize() : (long)requestedCount.intValue();
        if (fromRecord == -1L) {
            nxt = forwd;
            startingRecord = forwd ? -1L : (logFile.getLastIndexNumber() + 1L) * logFile.getIndexSize();
        } else {
            startingRecord = fromRecord;
            if (startingRecord < -1L) {
                throw new IllegalArgumentException("fromRecord must be greater than 0!");
            }
        }
        try {
            return this.fetchRecordsUsingQuery(logFile, startingRecord, nxt, forwd, reqCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "logging.backend.error.fetchrecord", ex);
            return new AttributeList();
        }
    }

    protected AttributeList fetchRecordsUsingQuery(LogFile logFile, long startingRecord, boolean next, boolean forward, long requestedCount, Date fromDate, Date toDate, String logLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        boolean origForward = forward;
        if (next) {
            ++startingRecord;
            forward = true;
        } else {
            forward = false;
        }
        int inc = 1;
        int start = 0;
        int end = -1;
        long searchChunkIncrement = requestedCount;
        if (!forward) {
            inc = -1;
            if ((startingRecord -= next ? searchChunkIncrement - 1L : searchChunkIncrement) < 0L) {
                searchChunkIncrement += startingRecord;
                startingRecord = 0L;
            }
        }
        ArrayList<LogFile.LogEntry> results = new ArrayList<LogFile.LogEntry>();
        List records = null;
        LogFile.LogEntry entry = null;
        while ((long)results.size() < requestedCount && (records = logFile.getLogEntries(startingRecord, searchChunkIncrement)) != null) {
            if (forward) {
                end = records.size();
            } else {
                start = records.size() - 1;
            }
            for (int count = start; count != end && (long)results.size() < requestedCount; count += inc) {
                entry = (LogFile.LogEntry)records.get(count);
                if (!this.allChecks(entry, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch)) continue;
                results.add(entry);
            }
            if (forward) {
                if ((long)records.size() < searchChunkIncrement) break;
                startingRecord += searchChunkIncrement * (long)inc;
                searchChunkIncrement = requestedCount - (long)results.size();
                continue;
            }
            if (startingRecord == 0L) break;
            searchChunkIncrement = requestedCount - (long)results.size();
            if ((startingRecord += searchChunkIncrement * (long)inc) >= 1L) continue;
            searchChunkIncrement += startingRecord;
            startingRecord = 0L;
        }
        if (next ^ origForward) {
            ArrayList reversedResults = new ArrayList();
            for (int count = results.size() - 1; count > -1; --count) {
                reversedResults.add(results.get(count));
            }
            results = reversedResults;
        }
        return this.convertResultsToTheStructure(results);
    }

    private AttributeList convertResultsToTheStructure(List results) {
        if (results == null) {
            return null;
        }
        AttributeList resultsInTemplate = new AttributeList();
        resultsInTemplate.add(LogRecordTemplate.getHeader());
        Iterator iterator = results.iterator();
        ArrayList listOfResults = new ArrayList();
        Attribute resultsAttribute = new Attribute(RESULTS_ATTRIBUTE, listOfResults);
        resultsInTemplate.add(resultsAttribute);
        while (iterator.hasNext()) {
            LogFile.LogEntry entry = (LogFile.LogEntry)iterator.next();
            ArrayList<Object> logRecord = new ArrayList<Object>();
            logRecord.add(new Long(entry.getRecordNumber()));
            logRecord.add(entry.getLoggedDateTime());
            logRecord.add(entry.getLoggedLevel());
            logRecord.add(entry.getLoggedProduct());
            logRecord.add(entry.getLoggedLoggerName());
            logRecord.add(entry.getLoggedNameValuePairs());
            logRecord.add(entry.getMessageId());
            logRecord.add(entry.getLoggedMessage());
            listOfResults.add(logRecord);
        }
        return resultsInTemplate;
    }

    public LogFile getLogFile() {
        return this._logFile;
    }

    public LogFile getLogFile(String fileName) {
        String logFileName = fileName.trim();
        LogFile logFile = (LogFile)logFileCache.get(fileName);
        String parent = null;
        if (logFile == null) {
            try {
                if (new File(fileName).exists()) {
                    logFile = new LogFile(fileName);
                    logFileCache.put(fileName, logFile);
                    return logFile;
                }
                parent = System.getProperty("com.sun.aas.instanceRoot");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "logging.backend.error", e);
            }
            if (parent != null) {
                String[] logFileNameParts = new String[]{parent, logFileName};
                logFileName = StringUtils.makeFilePath((String[])logFileNameParts, (boolean)false);
            }
            logFile = new LogFile(logFileName);
            logFileCache.put(fileName, logFile);
        }
        return logFile;
    }

    public synchronized void setLogFile(LogFile logFile) {
        this._logFile = logFile;
    }

    protected void updateModuleList(List listOfModules) {
        if (listOfModules == null) {
            return;
        }
        Iterator iterator = listOfModules.iterator();
    }

    protected boolean allChecks(LogFile.LogEntry entry, Date fromDate, Date toDate, String queryLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        return this.dateTimeCheck(entry.getLoggedDateTime(), fromDate, toDate) && this.levelCheck(entry.getLoggedLevel(), queryLevel, onlyLevel) && this.moduleCheck(entry.getLoggedLoggerName(), listOfModules) && this.nameValueCheck(entry.getLoggedNameValuePairs(), nameValueMap) && this.messageDataCheck(entry.getLoggedMessage(), entry.getLoggedNameValuePairs(), anySearch);
    }

    protected boolean dateTimeCheck(Date loggedDateTime, Date fromDateTime, Date toDateTime) {
        if (fromDateTime == null || toDateTime == null) {
            return true;
        }
        return !loggedDateTime.before(fromDateTime) && !loggedDateTime.after(toDateTime);
    }

    protected boolean levelCheck(String loggedLevel, String queryLevelIn, boolean isOnlyLevelFlag) {
        if (queryLevelIn == null) {
            return true;
        }
        String queryLevel = queryLevelIn.trim();
        if (isOnlyLevelFlag) {
            if (loggedLevel.equals(queryLevel)) {
                return true;
            }
        } else {
            for (int idx = 0; idx < LOG_LEVELS.length; ++idx) {
                if (loggedLevel.equals(LOG_LEVELS[idx])) {
                    return true;
                }
                if (LOG_LEVELS[idx].equals(queryLevel)) break;
            }
        }
        return false;
    }

    protected boolean moduleCheck(String loggerName, List modules) {
        if (modules == null || modules.size() == 0) {
            return true;
        }
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            if (!loggerName.startsWith((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean nameValueCheck(String loggedNameValuePairs, Properties queriedNameValueMap) {
        if (queriedNameValueMap == null || queriedNameValueMap.size() == 0) {
            return true;
        }
        if (loggedNameValuePairs == null) {
            return false;
        }
        StringTokenizer nvListTokenizer = new StringTokenizer(loggedNameValuePairs, NV_SEPARATOR);
        while (nvListTokenizer.hasMoreTokens()) {
            String nameandvalue = nvListTokenizer.nextToken();
            StringTokenizer nvToken = new StringTokenizer(nameandvalue, "=");
            if (nvToken.countTokens() < 2) continue;
            String loggedName = nvToken.nextToken();
            String loggedValue = nvToken.nextToken();
            for (Map.Entry<Object, Object> entry : queriedNameValueMap.entrySet()) {
                if (!entry.getKey().equals(loggedName)) continue;
                Object value = entry.getValue();
                Iterator iterator = ((List)value).iterator();
                while (iterator.hasNext()) {
                    if (!((String)iterator.next()).equals(loggedValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean messageDataCheck(String message, String nvp, String anySearch) {
        if (anySearch == null || "".contains(anySearch) || anySearch.length() < 3) {
            return true;
        }
        return message != null && message.contains(anySearch) || nvp != null && nvp.contains(anySearch);
    }
}

